% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspacesweb_operations.R
\name{workspacesweb_create_identity_provider}
\alias{workspacesweb_create_identity_provider}
\title{Creates an identity provider resource that is then associated with a web
portal}
\usage{
workspacesweb_create_identity_provider(
  clientToken = NULL,
  identityProviderDetails,
  identityProviderName,
  identityProviderType,
  portalArn,
  tags = NULL
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original request
completes successfully, subsequent retries with the same client token
returns the result from the original successful request.

If you do not specify a client token, one is automatically generated by
the Amazon Web Services SDK.}

\item{identityProviderDetails}{[required] The identity provider details. The following list describes the provider
detail keys for each identity provider type.
\itemize{
\item For Google and Login with Amazon:
\itemize{
\item \code{client_id}
\item \code{client_secret}
\item \code{authorize_scopes}
}
\item For Facebook:
\itemize{
\item \code{client_id}
\item \code{client_secret}
\item \code{authorize_scopes}
\item \code{api_version}
}
\item For Sign in with Apple:
\itemize{
\item \code{client_id}
\item \code{team_id}
\item \code{key_id}
\item \code{private_key}
\item \code{authorize_scopes}
}
\item For OIDC providers:
\itemize{
\item \code{client_id}
\item \code{client_secret}
\item \code{attributes_request_method}
\item \code{oidc_issuer}
\item \code{authorize_scopes}
\item \code{authorize_url} \emph{if not available from discovery URL specified
by oidc_issuer key}
\item \code{token_url} \emph{if not available from discovery URL specified by
oidc_issuer key}
\item \code{attributes_url} \emph{if not available from discovery URL specified
by oidc_issuer key}
\item \code{jwks_uri} \emph{if not available from discovery URL specified by
oidc_issuer key}
}
\item For SAML providers:
\itemize{
\item \code{MetadataFile} OR \code{MetadataURL}
\item \code{IDPSignout} (boolean) \emph{optional}
\item \code{IDPInit} (boolean) \emph{optional}
\item \code{RequestSigningAlgorithm} (string) \emph{optional} - Only accepts
\code{rsa-sha256}
\item \code{EncryptedResponses} (boolean) \emph{optional}
}
}}

\item{identityProviderName}{[required] The identity provider name.}

\item{identityProviderType}{[required] The identity provider type.}

\item{portalArn}{[required] The ARN of the web portal.}

\item{tags}{The tags to add to the identity provider resource. A tag is a key-value
pair.}
}
\description{
Creates an identity provider resource that is then associated with a web portal.

See \url{https://www.paws-r-sdk.com/docs/workspacesweb_create_identity_provider/} for full documentation.
}
\keyword{internal}
