% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{survey_mle}
\alias{survey_mle}
\title{Compute proportion in the survey sample (standard estimator)}
\usage{
survey_mle(R, n, pi0 = 0, alpha = 0, beta = 0, gamma = 0.05, V = NULL, ...)
}
\arguments{
\item{R}{A \code{numeric} that provides the people of positive people in the sample.}

\item{n}{A \code{numeric} that provides the sample size.}

\item{pi0}{A \code{numeric} that provides the prevalence or proportion of people (in the whole population) who are positive, as measured through a non-random,
but systematic sampling (e.g. based on medical selection). Default value is \code{0} and in this case this information is not used in the estimation procedure.}

\item{alpha}{A \code{numeric} that provides the False Negative (FN) rate for the sample R. Default value is \code{0}.}

\item{beta}{A \code{numeric} that provides the False Positive (FP) rate for the sample R. Default value is \code{0}.}

\item{gamma}{A \code{numeric} that is used to compute a (1 - gamma) confidence region for the proportion. Default value is \code{0.05}.}

\item{V}{A \code{numeric} that corresponds to the average of squared sampling weights. Default value is \code{NULL}.}

\item{...}{Additional arguments.}
}
\value{
A \code{cpreval} object with the structure:
\itemize{
 \item estimate:    Estimated proportion.
 \item sd:          Estimated standard error of the estimator.
 \item ci_asym:     Asymptotic confidence interval at the 1 - gamma confidence level.
 \item gamma:       Confidence level (i.e. 1 - gamma) for confidence intervals.
 \item method:      Estimation method (in this case sample survey).
 \item measurement: A vector with (alpha0, alpha, beta).
 \item boundary:    A boolean variable indicating if the estimates falls at the boundary of the parameter space.
 \item pi0:         Value of pi0 (input value).
 \item sampling:    Type of sampling considered ("random" or "weighted").
 \item V:           Average sum of squared sampling weights if weighted/stratified is used (otherwise NULL).
 \item ...:         Additional parameters.
}
}
\description{
Proportion estimated using the survey sample and confidence intervals based on the Clopper-Pearson and the standard
asymptotic approach.
}
\examples{
# Samples without measurement error
X = sim_Rs(theta = 30/1000, pi0 = 10/1000, n = 1500, seed = 18)
survey_mle(R = X$R, n = X$n)

# With measurement error
X = sim_Rs(theta = 30/1000, pi0 = 10/1000, n = 1500, alpha = 0.01, beta = 0.05, seed = 18)
survey_mle(R = X$R, n = X$n)
survey_mle(R = X$R, n = X$n, alpha = 0.01, beta = 0.05)
}
\author{
Stephane Guerrier, Maria-Pia Victoria-Feser, Christoph Kuzmics
}
