% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{update_prevalence}
\alias{update_prevalence}
\title{Update prevalence using new case prevalence rates}
\usage{
update_prevalence(
  pi0_new,
  x,
  gamma = 0.05,
  print = NULL,
  plot = NULL,
  col_line = "#2e5dc1",
  col_ci = "#2E5DC133",
  ...
)
}
\arguments{
\item{pi0_new}{A \code{numeric} or \code{vector} of new case prevalence rates}

\item{x}{A \code{cpreval} object.}

\item{gamma}{A \code{numeric} that used to compute a (1 - gamma) confidence region for the proportion. Default value is \code{0.05}.}

\item{print}{A \code{boolean} indicating whether or not the output should be print.}

\item{plot}{A \code{boolean} indicating whether or not a plot should be made.}

\item{col_line}{Color of the estimated prevalence.}

\item{col_ci}{Color of the estimated prevalence confidence interval.}

\item{...}{Additional arguments.}
}
\value{
A \code{matrix} object whose colunms corresponds to pi0, estimate, sd and CI.
}
\description{
Updated prevalence and confidence intervals using new case prevalence rates
}
\examples{
# Austrian data (November 2020)
pi0 = 93914/7166167
data("covid19_austria")

# Weighted sampling
n = nrow(covid19_austria)
R1w = sum(covid19_austria$weights[covid19_austria$Y == 1 & covid19_austria$Z == 1])
R2w = sum(covid19_austria$weights[covid19_austria$Y == 0 & covid19_austria$Z == 1])
R3w = sum(covid19_austria$weights[covid19_austria$Y == 1 & covid19_austria$Z == 0])
R4w = sum(covid19_austria$weights[covid19_austria$Y == 0 & covid19_austria$Z == 0])

# Assumed measurement errors
alpha0 = 0
alpha = 1/100
beta = 10/100

# MME
mme = moment_estimator(R3 = R3w, n = n, pi0 = pi0, alpha = alpha, beta = beta,
                       alpha0 = alpha0, V = mean(covid19_austria$weights^2))

mme

# Update prevalence using a new pi0, say = 1.5\%, instead of 1.31\%
update_prevalence(1.5/100, mme)

pi0_new = seq(from = 0.005, to = 0.03, length.out = 100)
update_prevalence(pi0_new, mme)

}
\author{
Stephane Guerrier
}
