% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo.R
\name{repo}
\alias{repo}
\title{Query and manipulate CRAN-like repositories}
\description{
These functions are currently experimental.
}
\details{
\subsection{List packages in a repository}{

\code{repo$list()} lists packages in a repository. It reads the \code{PACKAGES}
file containing the repository metadata.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{repo_list(..., path = ".")
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{...}: ignored currently.
\item \code{path}: path to repository. Must contain a \code{PACKAGES} file.
}
}

\subsection{Value}{

Data frame of package data, a data frame with at least the following
columns, possibly more if there are other entries in the metadata:
\itemize{
\item \code{Package}
\item \code{Version}
\item \code{Depends}
\item \code{Imports}
\item \code{Suggests}
\item \code{Enhances}
\item \code{LinkingTo}
\item \code{License}
\item \code{File}
\item \code{DownloadURL}
\item \code{OS}
\item \code{Arch}
\item \code{Built}
\item \code{Filesize}
\item \code{SHA256}
\item \code{RVersion}
\item \code{Platform}
\item \code{GraphicsAPIVersion}
\item \code{InternalsId}
\item \code{SystemRequirements}
}
}

}

\subsection{Delete packages from repository metadata}{

\code{repo$delete()} deletes matching packages from the repository
metadata.
\subsection{Description}{

All matching packages will be removed.
It does not delete the files themselves.
}

\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{repo$delete(package, ..., path = ".")
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{package}: package name.
\item \code{...}: other fields to match, they must be named. Matching is
case insensitive.
\item \code{path}: path to repository. Must contain a \code{PACKAGES} file.
}
}

}

\subsection{Add a package to a repository}{
\subsection{Description}{

It does not check if any version of the package is already
in the repository. If you want to \emph{update} a package, use
\code{repo$update()}.
}

\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{repo$add(file, ..., path = ".")
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item `file Package file.
\item `... Ignored currently.
\item \verb{path Path to repository. Must contain a }PACKAGES` file.
}
}

}

\subsection{Update a package in a repository}{
\subsection{Description}{

Previous version of the same package are removed. In particular,
it removes packages with matching:
\itemize{
\item package name (\code{Package} field),
\item R version (\code{Rversion} field),
\item same OS (\code{OS} field), or no \code{OS} field,
\item same architecture (\code{Arch} field), or not \code{Arch} field.
}
}

\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{repo$update(file, ..., path = ".")
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item `file Package file.
\item `... Ignored currently.
\item \verb{path Path to repository. Must contain a }PACKAGES` file.
}
}

}

\subsection{Update a file in a package metadata, stored on GitHub}{
\subsection{Description}{
\enumerate{
\item Clones the GitHub repository.
\item Calls \code{repo_update()} with \code{file}, in the \code{subdir} directory.
\item Adds and commits changes.
\item Pushes the git repository to GitHub.
If the push fails, then it resets the git repository, pulls it from
GitHub and tries the update process again, until the push succeeds.
}

This function needs command line git installed.

It sets up a \code{cache} credential helper, so the \verb{git push} works
without interaction with the user.
}

\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{repo$update_gh(repo, subdir, files)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{repo}: GitHub slug, e.g. \code{r-hub/repos}.
\item \code{subdir}: subdirectory in the GitHub repository, where the R package
metadata should be updated. It must exist in the repository.
If it does not have \verb{PACKAGES*} files, then they will be created.
\item \code{files}: package files to add. The files will \emph{not} be added to the
repository, only to the metadata. They should be in the repository
already.
}
}

}
}
\keyword{internal}
