% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ATE.R
\name{plot_PATE}
\alias{plot_PATE}
\title{Plot histogram or density of Population Average Treatment Effect}
\usage{
plot_PATE(
  .model,
  type = c("histogram", "density"),
  ci_80 = FALSE,
  ci_95 = FALSE,
  reference = NULL,
  .mean = FALSE,
  .median = FALSE
)
}
\arguments{
\item{.model}{a model produced by `bartCause::bartc()`}

\item{type}{histogram or density}

\item{ci_80}{TRUE/FALSE. Show the 80\% credible interval?}

\item{ci_95}{TRUE/FALSE. Show the 95\% credible interval?}

\item{reference}{numeric. Show a vertical reference line at this value}

\item{.mean}{TRUE/FALSE. Show the mean reference line}

\item{.median}{TRUE/FALSE. Show the median reference line}
}
\value{
ggplot object
}
\description{
Plot shows the Population Average Treatment Effect which is derived from the posterior predictive distribution of the difference between \eqn{y | z=1, X} and \eqn{y | z=0, X}.
Mean of PATE will resemble CATE and SATE but PATE will account for more uncertainty and is recommended for informing inferences on the average treatment effect.
}
\examples{
\donttest{
data(lalonde)
confounders <- c('age', 'educ', 'black', 'hisp', 'married', 'nodegr')
model_results <- bartCause::bartc(
 response = lalonde[['re78']],
 treatment = lalonde[['treat']],
 confounders = as.matrix(lalonde[, confounders]),
 estimand = 'ate',
 commonSup.rule = 'none'
)
plot_PATE(model_results)
}
}
\author{
George Perrett, Joseph Marlo
}
