% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pip_fountain.R
\name{pip_fountain}
\alias{pip_fountain}
\title{Posterior Interaction Profile - \emph{Fountain} style}
\usage{
pip_fountain(
  alpha,
  beta,
  distance_mat,
  gamma = NULL,
  alpha_lower = NULL,
  alpha_upper = NULL,
  distance_low = NULL,
  distance_up = NULL,
  item_group = NULL,
  focal_id = 1,
  density_adjust = 2,
  y_limits = NULL
)
}
\arguments{
\item{alpha}{Numeric vector of length \emph{N}. Posterior means (or draws) of
person ability parameters.}

\item{beta}{Numeric vector of length \emph{I}. Posterior means of item easiness
parameters.}

\item{distance_mat}{Numeric matrix \eqn{N \times I}{N x I} containing the latent distances
\eqn{d_{ij}} between persons and items.}

\item{gamma}{Optional numeric scalar used to multiplicatively rescale
all distances (and \code{distance_low}/\code{distance_up}, if provided) before
computing personalized easiness. Defaults to \code{NULL} (no rescaling).}

\item{alpha_lower, alpha_upper}{Optional numeric vectors (length \emph{N})
providing lower/upper posterior intervals (e.g., 95\% HDI) for each
respondent's \eqn{\alpha_j}.  The focal respondent's band is shaded.}

\item{distance_low, distance_up}{Optional matrices matching \code{distance_mat}
that give lower/upper HDI bounds for each distance.  When both are
supplied, dotted vertical lines depict the uncertainty in every
personalized easiness.}

\item{item_group}{Optional character/factor vector of length \emph{I} defining
item groupings.  Enables color coding and a legend.}

\item{focal_id}{Integer (1 \eqn{\le}{<=} \code{focal_id} \eqn{\le}{<=} \eqn{N}{N}) selecting the respondent to
highlight.  Defaults to the first row.}

\item{density_adjust}{Positive numeric scalar passed to
\code{ggplot2::geom_density(adjust = ...)} to control the smoothness of the
left-panel density estimate. Values > 1 increase the bandwidth (smoother
curve); values < 1 decrease it (more detail). Default is \code{2}.}

\item{y_limits}{Optional numeric length-2 vector \code{c(min, max)} that fixes the
y-axis range for both panels.}
}
\value{
A \code{patchwork} object containing the combined left- and right-hand
\code{ggplot2} panels.  The plot is automatically displayed; the value is
returned invisibly for further tweaking.
}
\description{
Generates the \strong{fountain} variant of a Posterior Interaction Profile (PIP)
plot.
The layout is identical to \code{\link[=pip_waterfall]{pip_waterfall()}} on the left (posterior
density for the focal respondent's ability) but \strong{inverts} the right-hand
panel: each item dot is placed at \emph{- \eqn{\beta_i}{beta[i]}} (the "fountain base") and an arrow
rises to the personalized easiness
\deqn{\delta_{ij} = \beta_i - d_{ij}}{delta[ij] = beta[i] - d[ij]}.
Distance is taken from \code{distance_mat}. If \code{gamma} is supplied, distances are
scaled before computing deltas, i.e. \eqn{\delta_{ij} = \beta_i - \gamma d_{ij}}{delta[ij] = beta[i] - gamma * d[ij]}.
Uncertainty bounds in \code{distance_low}/\code{distance_up} are scaled by the same \eqn{\gamma}{gamma}.
Arrows that extend \strong{above} the base indicate the item is \emph{easier} for the
respondent than average; arrows that fall short indicate it is \emph{harder}.
}
\examples{
# Small simulated example -----------------------------------------
set.seed(42)
N <- 6; I <- 10
alpha <- rnorm(N)
beta  <- rnorm(I, sd = 0.7)
dist  <- abs(matrix(rnorm(N * I, sd = 0.8), N, I))  # fake distances

# Plain fountain plot for respondent 2
pip_fountain(alpha, beta, gamma = 1.5, dist, focal_id = 2)

# Fountain plot with item groups and uncertainty intervals
grp <- rep(c("MCQ", "Essay"), length.out = I)
d_lo <- pmax(dist - 0.2, 0);  d_up <- dist + 0.2
a_lo <- alpha - 0.3; a_up <- alpha + 0.3
pip_fountain(alpha, beta, gamma = 1, dist,
             alpha_lower = a_lo, alpha_upper = a_up,
             distance_low = d_lo, distance_up = d_up,
             item_group = grp, focal_id = 4)

}
\seealso{
\code{\link[=pip_waterfall]{pip_waterfall()}} for the alternative "waterfall" framing, and
\code{\link[=interprofile]{interprofile()}} for a wrapper that switches between the two.
}
