
# poldis <img src="man/figures/poldishexlogo3.png" align="right" width="220"/>

<!-- badges: start -->

[![lifecycle](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental)
![GitHub release (latest by
date)](https://img.shields.io/github/v/release/henriquesposito/poldis)
![GitHub
issues](https://img.shields.io/github/issues-raw/henriquesposito/poldis)
![GitHub Release
Date](https://img.shields.io/github/release-date/henriquesposito/poldis)
[![Codecov test
coverage](https://codecov.io/gh/henriquesposito/poldis/branch/master/graph/badge.svg)](https://app.codecov.io/gh/henriquesposito/poldis?branch=master)
[![CodeFactor](https://www.codefactor.io/repository/github/henriquesposito/poldis/badge)](https://www.codefactor.io/repository/github/henriquesposito/poldis)
<!-- badges: end -->

`{poldis}`: an R package that provides tools for analyzing political
discourses over time!

# Why `{poldis}`?

`{poldis}` provides the tools necessary to work with political discourse
texts, making it easier to analyse political discourses that are less
structured and frequently involve multiple actors and topics. Political
discourse data come in many different forms, ranging from single-speaker
speeches to debates. While other R packages allow us to analyse data
from single-speaker speeches easily, this only reveals a portion of the
what, how, and where politics “gets done”. For most other settings where
political discourse appears as debates, interviews, news conferences, or
campaign rallies, working with text programmatically becomes tricky
where there may be multiple speakers, questions, different languages,
and other types of “noise” in text data. Texts might need to be
separated by speakers, have questions removed for analysis, or retain
only the context around specific topics and keywords. The package
contains the tools required for wrangling and annotating these different
types of political discourse texts within R.

Beyond these basic tools for text analysis, `{poldis}` also introduces
tools for Urgency Analysis (UA), a new method for the analysis of
urgency in political texts. Urgency is an expression of how critical or
immediate problems or solutions are in political discourse. UA rests
upon a multidimensional, weighted, and survey-validated conception of
how urgency can be expressed in political discourses. It combines
Natural Language Processes (NLP) and dictionary approaches to provide a
contextualized, comparable, and scalable new method for the analysis of
political texts.

# Installing the package

The easiest way to install `{poldis}` is directly from CRAN:

``` r
install.packages("poldis")
library(poldis)
```

However, you may also install the development version from
[GitHub](https://github.com/).

``` r
# install.packages("remotes")
remotes::install_github("henriquesposito/poldis")
library(poldis)
```

# Getting started

`{poldis}` offers several text tools for wrangling texts within R. For
example, users can extract the context surrounding a specific string in
the text.

``` r
set.seed(1234)
text <- sample(US_News_Conferences_1960_1980$text, 2, replace = TRUE)
extract_context(" war ", text, level = "sentences", n = 1)
```

    ## [[1]]
    ## [1] " We do a good many things.,Now, coming down to the question which is rather sidestepped, that is, if the United States should go to war in order to remove Castro. That nettle is not grasped, and it would seem to me that we have pretty much done all of those things that can be done to demonstrate hostility to the concept of a Soviet satellite in the Caribbean except take these other steps which bring in their wake violence, and may bring a good deal of worldwide difficulty."
    ## 
    ## [[2]]
    ## [1] " President, did you limit yourself to this global theme?,THE PRESIDENT. Well, because the issue of war and peace is involved, and the survival of perhaps the planet, possibly our system. And, therefore, this is a matter of primary concern to the people of the United States and the people of the world."

Other text functions in the ‘extract’ family of functions include
`extract_names()`, that uses NLP to extract names of persons refereed to
in the text, and `extract_text_similarities()`, that compares textual
similarities for multiple texts.

# Annotating text

With `annotate_text()`, text annotations are offered at the word (token)
and sentence levels. The annotated syntax metadata helps to code words
or sentences (e.g. code adverbs or adjectives where/when present) and
avoid false positive matches. Please see the help page
(`?annotate_text`) for details on the algorithm used to annotate texts.

``` r
annotate_text(text, level = "words")
annotate_text(text, level = "sentences")
```

# Selecting political priorities

`select_priorities()` allows political priorities (i.e. statements in
which actors express their intent or commitment to take political action
in the future) to be extracted once texts have been annotated.
priorities are captured by identifying sentences containing modal verbs
(e.g. must) and other indications of future-oriented sentences with our
custom-built dictionaries (e.g. need to, going to).

``` r
select_priorities(text)
```

# Gathering topics

We automate topic generation for political texts by constructing a
custom-built dictionary of terms for capturing 20 major political topics
based on the [Comparative Agendas
Projects](https://www.comparativeagendas.net/) (Jones et al., 2023).
Topics are assigned when words related to subjects appear in texts.
Alternatively, users can also declare their own dictionary for topics.

``` r
gather_topics(text)
```

    ## [1] "Macroeconomics, Civil Rights  Minority Issues  and Civil Liberties, Health, Labor and Employment, Education, Energy, Immigration, Transportation, Law  Crime  and Family Issues, Community Development and Housing Issues, Banking  Finance  and Domestic Commerce, Defense, Space  Science  Technology  and Communications, Foreign Trade, International Affairs and Foreign Aid, Government Operations, Public Lands and Water Management"
    ## [2] "Macroeconomics, Health, Agriculture, Labor and Employment, Education, Immigration, Law  Crime  and Family Issues, Social Welfare, Community Development and Housing Issues, Defense, Space  Science  Technology  and Communications, Foreign Trade, International Affairs and Foreign Aid, Government Operations"                                                                                                                           
    ## attr(,"class")
    ## [1] "topics"

# Measuring urgency

Urgency is an expression of how necessary and/or how soon a political
action should be undertaken. We code four dimensions of urgency in
political discourses using purpose-built dictionaries of terms:
frequency, timing, intensity, and commitment. For more details on
conceptualising and measuring urgency, please contact us for the working
paper introducing Urgency Analysis.

``` r
get_urgency(text)
```

    ##                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 .data
    ## 1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              THE PRESIDENT. Good afternoon.,[1.] Prime Minister Pearson of Canada and I have agreed to meet at Hyannis Port, Mass., on May 10 and 11 for a first discussion of the many important questions that are of common interest to the two countries.,[2.] Secondly, Under Secretary of State for Political Affairs W. Averell Harriman, having consulted in Paris with French Foreign Minister Couve de Murville and in London with Foreign Secretary Lord Home, British Co-chairman of the International Control Commission for Laos, will proceed to Moscow tomorrow to discuss the Laotian situation with the Soviet Co-chairman, Foreign Minister Andrei Gromyko. He does have a short message for Premier Khrushchev from me, explaining the purposes of his trip.,[3.] Q. Mr. President, with Laos boiling up, could you assess for us the relative threats posed to the United States by the Soviet Union and Red China?,THE PRESIDENT. No, I think it would be a mistake to attempt to make that assessment on this occasion. We have difficult problems in Southeast Asia. They directly involve, of course, the Soviet Union, as the Soviet Union is the co-chairman and is also, as I have already said, a signatory to the Geneva accord. It has assumed in the past a special responsibility for the maintenance of a neutral and independent Laos, in the Vienna statement which the Chairman and I made in June 1961,1 committing ourselves to that result. We have also of course been conscious of the threat to the security of independent countries of Asia and Southeast Asia, which has been made quite clear by the Chinese. So I would say that we have serious problems with them both. We would hope that the Soviet Union would make an effort to fulfill its commitments under the Geneva accord as the United States is attempting to do.,1 See 1961 volume, this series, Item 225.,[4.] Q. Mr. President, there were reports from Moscow earlier today that the British and American Ambassadors during their meeting with Chairman Khrushchev had presented a new proposal on inspection in an effort to break the deadlock on the nuclear test ban treaty negotiations. Is it correct that the United States has presented such a proposal, and is there anything you can tell us about prospects now on this issue?,THE PRESIDENT. The United States made proposals for intensification of the negotiations and suggested some procedures by which those negotiations might be speeded up. I am not overly sanguine about the prospects for an accord. We have been caught, really, since December, on the disagreement between the number of tests that should take place in any one year--the United States discussing seven and the Soviet Union three. No movement from the Soviet Union has taken place. In addition there are other details which are still unresolved, not so much the matter of tests but the area of inspection, the means by which the inspection will be carried out, the freedom of the teams, and what will be the composition of the inspection teams; all these questions are still unresolved.,As we feel time is running out, the Prime Minister and I wrote to Chairman Khrushchev in an effort to see if we could develop some means by which we could bring this matter to a climax and see if we could reach an accord, which we feel to be in the interest of the nuclear powers, the present nuclear powers, to prevent diffusion. But, as I say, I am not sanguine and this represents not a last effort but a very determined effort to see if we can prevent failure from coming upon us this spring.,[5.] Q. Mr. President, back on Laos, it has been more of a testing ground for coexistence since the Geneva accord than perhaps any other place in the world. Would you interpret a Soviet refusal to go along with efforts to maintain peace in the government of national union there as a shift toward a hard line by the Soviet Union?,THE PRESIDENT. Well, I don't want to say anything that will prejudice Secretary Harriman's trip. I think we will know a good deal more about the prospects after he has visited Moscow. Quite obviously, we regard the maintenance of the Geneva accord as very essential to the security of Laos itself, and also, as you quite rightly say, as a test of whether it is possible for an accord to be reached between countries which have serious differences, an accord to be reached and maintained.,If we fail in Laos, then I would think the prospects for accords on matters which may be geographically closer to us would be substantially lessened. But I think we will have an idea as to whether the Soviet Union is prepared to meet its commitments and whether the other countries who are also signatories--which include the Communist Chinese and the North Vietnamese, and others--are prepared to really see a neutral and independent Laos, or determined to try a military takeover. I think we should have a clearer idea of that after Governor Harriman's return.,Q. Could I ask just one more question on Laos? Do we have any evidence that the Soviet Union is not in control of the ground in Laos, as they seemed to be in control in 1961 and last year, when the Geneva agreement was signed?,THE PRESIDENT. Well, that, I think, is a matter which I think time will tell us. There was a direct control because of the supply lines which were being maintained by the Soviet airlift. Whether the Soviets maintain the same degree of control now, whether they desire to maintain their influence, and whether their influence will be thrown in the direction of a maintenance of the Geneva settlement are the questions which I think we should find answered in the next 3 or 4 weeks.,What, of course, is happening in Laos is a struggle between the neutralist forces of Kong Le, who were allied with the Communist forces in 1961. So that it seems to me that the very nature of the struggle and the forces that are involved in the struggle are the best answer to the charges that have been made in the last 24 hours, that it is the United States which has disturbed the status quo. The struggle is not between the forces of Phoumi and the neutralists, but between the Pathet Lao and the Kong Le forces which, of course, are the army of Souvanna Phouma, whom the Communists themselves supported in 1961. So I think we have a very clear idea of where the responsibility lies, and it would be a distortion to attempt to place the burden for the breakdown upon the United States.,I think the world can tell very clearly who is struggling in the Plaine des Jarres and who, therefore, must bear the responsibility. Now, the solution is not to engage in polemics or debate, but to bring about a cease-fire, and to see if we can maintain what is a very fragile structure today.,[6.] Q. Mr. President, how do you feel about the recommendations of the National Academy of Sciences and also of Professor John Rock of Harvard, that the Federal Government should participate actively in an attack on uncontrolled population growth?,THE PRESIDENT. Well, I don't know--I am familiar with the general thesis of Professor Rock. As you know, the United States Government today, through the National Institutes of Health, gives assistance to research in the whole area of fertility, biological studies, reproduction, and all the rest, which I think are important studies, and there are several millions of dollars of Federal funds involved, and I think they are very useful and should be continued.,Q. I think the recommendations are that our Government should take the lead and should participate much more actively and strongly than it has done before. You, sir, have never taken a position on this, I believe.,THE PRESIDENT. Well, what is your question?,Q. The question is: Will you accept the recommendations of the National Academy that we should participate in international birth control studies--supply funds?,THE PRESIDENT. Well, we are participating in the study of fertility and reproduction in the United Nations, which is an international study, at the present time. Now, if your question is: Can we do more, should we know more about the whole reproduction cycle, and should this information be made more available to the world so that everyone can make their own judgment, I would think that it would be a matter which we could certainly support. Whether we are going to support Dr. Rock's proposal, which is somewhat different, is another question.,[7.] Q. Mr. President, do you see any prospect for a meeting between yourself and Mr. Khrushchev any time in the next couple of months, in Europe, for example?,THE PRESIDENT. No, I haven't heard any, and there is none planned.,Q. The British, according to reports from London, are hoping for a three-way summit perhaps on the test ban.,THE PRESIDENT. There is none planned, and it doesn't seem to me that it would be useful unless we were in agreement upon a test ban, which we are not now.,[8.] Q. Mr. President, would you care to address yourself to criticism expressed by some Republicans, including Mr. Nixon recently, about the administration's attitude toward Cuba, and suggesting, perhaps, that we are not taking as firm a stand toward them as we should? Would you care to speak to that, sir?,THE PRESIDENT. No. I know there is a good deal of concern in the United States because Castro is still there. I think it is unfortunate that he was permitted to assume control in the 1950's, and perhaps it would have been easier to take an action then than it is now. But those who were in positions of responsibility did not make that judgment.,Now, as to what the present situation--we have, as you know, without going through the entire list, we have--and the other countries of the free world have--cut free world trade in the last 2 years from $800 million to $80 million. We are working with the OAS to set up an organization which will limit the movement of potential guerrillas in and out of Cuba. We have--the OAS have almost diplomatically isolated Castro in this hemisphere. I think the members of the OAS have made it very clear that Marxist-Leninism and the Soviet presence is not a matter which is acceptable to the people of the hemisphere. We have been working through the Alliance for Progress to prevent a repetition of the Cuba incident. We have made it very clear that we would not accept a Hungary in Cuba. We have made it very clear we would not permit the movement of troops from Cuba to another country for offensive purposes. We maintain surveillance. We do a good many things.,Now, coming down to the question which is rather sidestepped, that is, if the United States should go to war in order to remove Castro. That nettle is not grasped, and it would seem to me that we have pretty much done all of those things that can be done to demonstrate hostility to the concept of a Soviet satellite in the Caribbean except take these other steps which bring in their wake violence, and may bring a good deal of worldwide difficulty. If they are advocating that, then I recognize that as an alternate policy, but if it is merely a policy which says that we should do something without defining it, except perhaps as I have said, unleashing the exiles, which cannot do the job, it seems to me that we deserve in a question of this importance a good deal more precision in our prescriptions for its solution.,Q. Mr. President, now that the 21 Americans who were imprisoned in Cuba have been released, what do you think that the U.S. policy will be toward exile raids in the future if no U.S. laws are violated, and if these raids may have some military value, perhaps done in conjunction with the underground within Cuba?,THE PRESIDENT. Well, I would think a discussion of that kind of a question, if the question is as you put it, is really not very useful to the exiles, or to the cause of Cuba. It does not seem to me that public discussion of these sorts of activities is worthwhile at this time, or beneficial.,[9.] Q. Mr. President, I understand that at the request of the Defense Department, the United States Information Agency is now supplying two 5-minute commentaries daily on international affairs which are being broadcast by Armed Forces Radio Service transmitters on both the East and West Coasts, and in Germany. And I would like to respectfully ask you whether you feel it is the business of an official Federal agency to be disseminating comment and opinion to our citizen soldiers and their families overseas.,THE PRESIDENT. What did these programs consist of that is objectionable?,Q. Comment and opinion on international affairs.,THE PRESIDENT. Well, is there anything about the comment that is at all objectionable or slanted?,Q. I am not overseas, and so I haven't heard them.,THE PRESIDENT. Well, I'll be glad-[laughter]--you and I share--[laughter]-I would be glad to check into it and find out if there is anything that is improper about it.,[10.] Q. Mr. President, France is not on your itinerary for this summer, and apparently no invitation has been extended, and certainly you have not solicited one, but I wonder in the light of Secretary Rusk's talk with President de Gaulle if you think a talk between yourself and President de Gaulle would be useful this summer?,THE PRESIDENT. Well, I went to France last year. We are going to go to Italy and Germany and Ireland for good reasons in every case. We have not--I think actually according to protocol, which need not stand in our way, it would be the time for the French President to come to the United States. I think General de Gaulle would be glad to come or, protocol aside, I would be glad to go to France if there were some matters which we felt an exchange, a personal exchange would solve. I think that perhaps both of us feel that on those matters which concern us in common, France and the United States, that they can be best discussed at the diplomatic level.,[11.] Q. Another point on the exile problem, sir, rather in line with an admonition that you yourself made last December; the Attorney General suggested the other day that the Cuban exiles should compose their differences and speak with more of one voice, particularly in terms of their relationship with the Government. Is there an implication here, sir, of an approval or enthusiastic approval on the part of your administration toward the setting up of an exile government, a government in exile?,THE PRESIDENT. No, we supported the arrangement of the Revolutionary Council in order to give the exiles a voice which we hoped would be speaking for the exile community in all those matters which affect their relations with the United States and the United States Government. For us to agree and support a government in exile, however, is an entirely different question, because you have to--we would want to support a government which would strike a responsive chord in Cuba itself. The experience with governments in exile have not been particularly felicitous, historically speaking. There is no evidence that exiles themselves could develop a government which would necessarily be the government which the people of Cuba would freely choose.,It would seem to me what would be most valuable now would be a greater degree of cohesion among the exiles regardless of their political view, and there are substantial differences among them, so that they can negotiate with us, if that is the proper word, and bring their case before other Latin American countries, in the OAS, so that we can talk to someone about the many problems which we face and the exiles face with 200,000--250,000 people coming into our country- But a government in exile, I think that is a different question, and in my view it would be imprudent today and I don't think it would help the struggle.,[12.] Q. Mr. President, Senator Keating says that according to his information there has been no reduction in the number of Russian troops in Cuba. He said several thousand have left, several thousand have arrived there, with no change in the overall number since November. Would you care to comment?,THE PRESIDENT. Yes. I have already said that the best information we have from the intelligence community--and I rely upon the Director of the Central Intelligence Agency as chairman of the intergovernmental intelligence community for the information which I have given publicly. We attempt to ask any Congressman or Senator who has information to the contrary for his sources so they can be evaluated. I have stated that our information was, I think the last time we met, that 4,000, we thought, left in March, and that no substantial number had come in this winter. There is some evidence that some have left in April, but not a large number. Of course, the equipment itself seems to still be there, however, so that I would think there has been some reduction this winter in the number of Russian personnel on the island. There has not been a substantial reduction in the equipment. There has been no evidence, however, of any substantial introduction.,It is not, in my opinion, a grave question as to whether there's 17,000, 15,000, 13,000. There are still important elements on the island, and there's still Soviet equipment on the island. So I don't think Senator Keating and I are debating a serious question, unless there is a challenge on one side or the other of good faith, and I am sure there isn't. It is our best information that 4,000 or 5,000 have left since January and that there has not been an equal number come in. In fact, much, much less--300 or 400 at the most. That's our best evidence and I repeat it as it has been gathered by our intelligence sources.,[13.] Q. Mr. President, you have rejected the Civil Rights Commission's proposal for the withholding of funds from the State of Mississippi in particular; yet Negroes and other persons in some Southern States are encountering violence and the withholding of some of their rights. Could you discuss with us what alternative steps the Federal Government might be able to take to bring some of these States into line with the law of the land?,THE PRESIDENT. Well, in every case that the Civil Rights Commission described, the United States Government has instituted legal action in order to provide a remedy. The Civil Rights Commission gave a number of cases, the dogs, of a denial of equal rights at the airline terminal, and all of the rest. We are attempting through the established procedures set out by the United States Constitution to give protection, through lawsuits, through decisions by the courts, and a good deal of action has been taken in all of these cases.,Now, it is very difficult. We had outrageous crime, from all accounts, in the State of Alabama, in the shooting of the postman who was attempting in a very traditional way to dramatize the plight of some of our citizens, being assassinated on the road. We have offered to the State of Alabama the services of the FBI in the solution of the crime. We do not have direct jurisdiction, but we are working with every legislative, legal tool at our command to insure protection for the rights of our citizens, and we shall continue to do so.,We shall also continue not to spend Federal funds in such a way as to encourage discrimination. What they were suggesting was something different, which was a blanket withdrawal of Federal expenditures from a State. I said that I didn't have the power to do so, and I do not think the President should be given that power, because it could be used in other ways differently.,But I can just say to you that the Federal Government has been extremely active in the State of Mississippi, from before Oxford and since, in an attempt to provide for constitutional guarantees. We hope the State of Mississippi will do it, we hope the local police will do it, we hope the mayors will do it. Where they don't do it, the Federal Government will do it within the limits of our authority.,[14.] Q. Mr. President, Budget Director Gordon says there are fewer Federal employees for every hundred people today than in 1952 or 1957. Much of the press has always given the opposite impression. Hasn't the administration been making correct information available, or do you think this is an instance, perhaps, of the press managing the news?,THE PRESIDENT. Well, I would not ever suggest that anyone would manage the news. You have two kinds of statistics. One, you have Federal employment rising and therefore that's printed. That's news. Federal employment is rising. Then you have the question of whether Federal employment is rising in relation to the population, and it isn't. It is, as you suggested, declining. Federal expenditures in relationship to the population--nondefense expenditures--are declining. The Federal debt in relationship to the gross national product is declining. The Federal debt has gone up in the last 15 years, but in relationship to the gross national product it is declining. It seems to me this is the framework in which these statistics should best be put. If the population increases 3 or 4 million a year it's quite obvious you are going to have to have additional services. But the question is whether this increase is excessive. And, in nearly every case, in percentage of expenditures and in employment we have gone down.,I hoped the budget would make that point, because otherwise the people get an impression that there are excessive expenditures by the National Government; that we are in a very difficult economic position, when the fact of the matter is our national debt was 120 percent of our gross national product 15 years ago, and today it's 53 percent. So we are far stronger economically than we were 15 years ago. We are far stronger economically than we were 10 years ago or 5 years ago. And we have every chance to be far stronger through this decade if we will follow monetary and fiscal policies that encourage the growth of this country instead of stifling it.,And one of the reasons why I think we have such difficulty getting an acceptance of our expenditures and our tax policies is because people misread the statistics or are misled.,[15.] Q. Mr. President, this has to do with the Wall Street Journal survey on grassroots apathy which has just been published. Do you agree, sir, that such apathy actually exists, and if so, how do you account for it, and if it does exist, what do you plan to do about eliminating it?,THE PRESIDENT. Every April the Wall Street Journal writes a story on the left-hand side of the paper, reporting that Congressmen who have come back find great apathy about the President's programs. [Laughter] The fact of the matter is that in the last month we have had five or six important votes on the floor of the House and the floor of the Senate which I think indicates a support of a program of expansion for the United States economy. Today we are going to pass in the House of Representatives, I am sure, a bill to assist us in building medical schools so we will have enough doctors.,We passed the other day in the Senate a bill on mass transit. We passed a bill yesterday to provide important research facilities for water, which we are going to need greatly in the United States in the next 20 or 30 years. We are going to pass other programs. So I don't accept that at all. If we can get a chance to get these bills on the floor of the House so that they can be voted upon--through the Rules Committee, and give the Members a chance to vote for them--in my opinion this program to a substantial degree will pass. The only thing that has ever concerned me is whether the Rules Committee of the House of Representatives will release it for a vote. But if they release it for a vote, I think that the Members of the House will make very clear that the American people are still committed to progress on all of these fronts, which I believe is essential if we are going to maintain a viable economy. So that I think that is the best answer to the Wall Street Journal.,[16.] Q. Mr. President, on Laos again, several years ago we heard a great deal about the "falling domino" theory in Southeast Asia. Do you look upon Laos in terms of that country alone, or is your concern the effect that its loss would have in Thailand, Viet-Nam, and so on? Would you discuss that?,THE PRESIDENT. That is correct. The population of Laos is 2 million and it is scattered. It's very rough country. It's important as a sovereign power, the people desire to be independent, and it is also important because it borders the Mekong River and, quite obviously, if Laos fell into Communist hands it would increase the danger along the northern frontiers of Thailand. It would put additional pressure on Cambodia and would put additional pressure on South Viet-Nam, which in itself would put additional pressure on Malaya.,So I do accept the view that there is an interrelationship in these countries and that is one of the reasons why we are concerned with maintaining the Geneva accords as a method of maintaining stability in Southeast Asia. It may be one of the reasons why others do not share that interest.,[17.] Q. Mr. President, there has been suggestion in the Congress that the Government, the United States Government, might use more effectively the vehicle of the Organization of American States in the Cuban problem. I know there have been certain things done there already. And I understand that we are now prepared to go to the OAS shortly with a plan for intensified security measures. I wonder if you could discuss those and also whether you think there is general support among the Latin American countries for such a program?,THE PRESIDENT. Yes. Out of the San Jose meeting some proposals came which were amplified by the Managua meeting for providing additional security, which we presented to the OAS. In addition, the whole Alliance for Progress will pass through the OAS machinery. The efforts we are taking on surveillance is a result of an action of the OAS. So I think that the OAS is very active, even though I think we recognize the particular responsibilities we bear because of our geography and also because of our military strength.,[18.] Q. Mr. President, you have no intention to withdraw funds from the Civil Rights Commission, do you?,THE PRESIDENT. No, I don't. No.,[19.] Q. Sir, this regards the agreements with Soviet Russia, between the United States and Soviet Russia, regarding programs in outer space. We have two that are about ready. Those are not coming back to the Senate for ratification, I don't believe. I wonder why?,THE PRESIDENT. Well, the kinds of agreements--the executive agreements to cooperate on weather? That is not a treaty.,Q. Well, should it not be a treaty?,THE PRESIDENT. No, it doesn't seem to me that it involves issues which are substantive enough to warrant a treaty. The Congress has been kept fully informed. It is an exchange of information on weather and customarily that is not submitted to the Senate for treaty ratification. Any substantive agreement involving issues, for example, a test ban treaty, multilateral force, those sorts of issues, will definitely be submitted to the Senate.,[20.] Q. Mr. President, there seems to be a fairly lively debate developing on the question of the wisdom of our man-to-the-moon program and the amount of money that we have assigned to it. Have you had any cause at all to reconsider your commitment to that goal?,THE PRESIDENT. Well, we are looking at-we looked at it, of course, when we proposed our budget for this year. We are looking at it again in relationship to next year's budget. We are also looking at it because of the concern that has been raised in the Congress and out of the Congress. I have seen nothing, however, that has changed my mind about the desirability of our continuing this program.,Now, some people say that we should take the money we are putting into space and put it into housing or education. We sent up a very extensive educational program. My judgment is that what would happen would be that they would cut the space program and you would not get additional funds for education. We have enough resources, in my opinion, to do what needs to be done in the field, for example, of education, and to do what needs to be done in space.,Now, this program passed almost unanimously a year ago. What will happen, I predict, will be a desire perhaps, possibly, to cut it substantially, and then, a year from now or 6 months from now, when the Soviet Union has made another new, dramatic breakthrough, there will be a feeling of why didn't we do more. I think our program is soundly based. I strongly support it. I think it would be a mistake to cut it. I think time will prove, even though we can't see all the answers which we will find in space, that the overall expenditures have been worthwhile. This country is a country of great resources. This program in many ways is going to stimulate science. I know there is a feeling that the scientists should be working on some other matter, but I think that this program--I am for it and I think it would be a mistake to arrest it.,[21.] Q. Mr. President, there is reported to be a growing feeling on Capitol Hill that because of the brightening economic picture it might not be necessary to push your tax bill, that is, it might be all right to delay the effective date of your tax bill. Do you share that?,THE PRESIDENT. No, I don't agree with that at all. The fact of the matter is that the economy today is moving along at relatively the same figure as was estimated by the Council of Economic Advisers. It might be about $2 billion more. But the fact is I think that one of the reasons why the economy has moved along has been partly the level of governmental expenditures, combined, of course, with the private vitality in the economy, and also the prospect of the tax cut. The tax cut would put $10 billion directly, in an 18-month period, into the hands of our people, which under the multiplier will mean $30 billion, and I think can make a very important difference in reducing our unemployment. We have to find a tremendous number of jobs in the next 2 years for new people, and, in addition, we have a 5.6 percent level of unemployment already.,So I think it would be a great mistake to stop the tax cut. It is a long-range program. And it would be a great mistake to delay it, because we have all been through experiences, even in the last 12 months, to know that no one predicts with certainty the level of the economy. And I think the prudent action is to go ahead with the program we suggested.\nReporter: Thank you, Mr. President.
    ## 2 THE PRESIDENT. I have several announcements to make first.,[1] I have a statement about the Geneva negotiations for an atomic test ban. These negotiations, as you I now, are scheduled to begin early in February. They are of great importance and we will need more time to prepare a clear American position. So we are consulting with other governments and are asking to have it put off until late March. As you know, Mr. John McCloy is my principal adviser in this field, and he has organized a distinguished panel of experts, headed by Dr. James Fisk of the Bell Laboratories--and Mr. Salinger will have a list of the names at the end of the conference-who are going to study previous positions that we've taken in this field, and also recommend to Mr. McCloy, for my guidance, what our position will be in late March when we hope the tests will resume.,[2.] Secondly, the United States Government has decided to increase substantially its contribution towards relieving the famine in the Congo. This will be done by increasing the supply of cornmeal and dry milk, by adding contributions of rice, and by airlifting a thousand tons of food supplies, seeds, and hospital supplies from a number of African nations to the Congo.,It is the intention of the United States Government to meet fully the emergency requirements of the Congo for rice, corn, dry milk and other foodstuffs in our surplus stocks. Assurances have been received from the United Nations that with the help of this program the flow of supplies will be adequate to relieve the distress. The United States Government will cooperate fully to help the United Nations prevent famine in the Congo. 1,1 A White House release, dated January 25, describes more fully the Emergency Food Program for the Congo. The release is printed in the Department of State Bulletin (vol. 44, p. 218).,[3.] Third, I am happy to be able to announce that Capt. Freeman B. Olmstead and Capt. John R. McKone, members of the crew of the United States Air Force RB-47 aircraft who have been detained by Soviet authorities since July 1, 1960, have been released by the Soviet Government and are now en route to the United States.,The United States Government is gratified by this decision of the Soviet Union and considers that this action of the Soviet Government removes a serious obstacle to improvement of Soviet-American relations.,Our deepest sympathy and understanding go to the families of the men of the RB-47 who gave their lives in the service of their country. At the same time, I am sure that all Americans join me in rejoicing with the Olmstead and McKone families. The families, as well as the men, comported themselves in these trying times in a way which is truly in the best traditions of the military services of the United States. Restraint in these conditions is obviously not easy. But they can be assured that they have contributed in large measure to the final achievement of the objective which we all sought-release of the men.,[4.] Q. Mr. President, this RB-47 case was regarded by the Russians as an overflight although we took a different position. In the light of this announcement, what will be your general policy on overflights and on such things as the U-2 case, or the U-2 flights? Do you conceive of circumstances which might warrant resumption of such things as the U-2 flight?,THE PRESIDENT. The Soviet Government is fully aware of United States Government views with respect to the distinction between the question of the United States Air Force RB-47 and the incident which occurred over Soviet territory on May 1, 1960, involving an American U-2 type aircraft. Flights of American aircraft penetrating the air space of the Soviet Union have been suspended since May 1960. I have ordered that they not be resumed.,[5.] Q. Mr. President there have been reports that Mr. Khrushchev might come to the United Nations General Assembly for the resumption of the disarmament debates sometime in March. If this were to happen, would you welcome a visit by him to Washington for a get-acquainted meeting?,THE PRESIDENT. I've not heard officially of any proposal by Mr. Khrushchev to come to the United States. I've merely seen newspaper reports and I feel that it would be more appropriate to wait until we had some indication of whether Mr. Khrushchev was planning to come to the United Nations.,[6.] Q. Mr. President, can you tell us something about what your role was, if you had one, in the release of these fliers? Did this come about as a consequence of some action you took?,THE PRESIDENT. Well, this matter has been under discussion by the American Ambassador and Mr. Khrushchev on one occasion and representatives of the Soviet foreign ministry since this weekend. The fliers were released as of 2 a.m. yesterday morning, but in the plane taking off there was a tire that was blown and therefore the plane did not take off. Our last information is that it took off at 5 o'clock our time this afternoon. It will fly to Amsterdam and then we expect the fliers to be brought to the United States tomorrow afternoon.,[7.] Q. Mr. President, one of your task forces recommended that you resist any early move toward general disarmament negotiations until a firm and fixed U.S. policy could be worked out. What is your reaction to that report and how much time do you think it might take to get a firm fixed U.S. position?,THE PRESIDENT. Well, Mr. McCloy has responsibility over the area of disarmament as well as nuclear testing. He has, as I've said, set up this committee--advisory committee-on nuclear testing. We expect to also get the American position clearer on general disarmament. There is not the same deadline that we've been facing on the nuclear testing where we were supposed to resume in early February, but I can state that this was a matter which was discussed early this week by the Secretary of Defense and the Secretary of State and Mr. McCloy and we are preparing clarification of American positions on disarmament.,[8.] Q. Mr. President, what more can you tell us about the long conversation that Ambassador Thompson had with Mr. Khrushchev, including whether the tone of that conversation was anywhere near as friendly as that of the messages that Khrushchev has sent you?,THE PRESIDENT. I would say the tone was friendly. And as a result of the conversations, as I've said, the decision was made to release the fliers. But the conversations were conducted in an atmosphere of civility.,Q. Could you give us any indication at all as to what other subjects were taken up in addition to the release of the RB-47 fliers?,THE PRESIDENT. No. I think that I have to stand on my previous statement.,[9.] Q. Does your administration plan to take any steps to solve the problem at Fayette County, Tenn., where tenant farmers have been evicted from their homes because they voted last November and must now live in tents?,THE PRESIDENT. We are--the Congress, of course, enacted legislation which placed very clear responsibility on the executive branch to protect the right of voting. I supported that legislation. I am extremely interested in making sure that every American is given the right to cast his vote without prejudice to his rights as a citizen. And therefore I can state that this administration will pursue the problem of providing that protection with all vigor.,[10.] Q. Sir, would you please tell us how it was possible for you to do by Executive order what Mr. Benson always told us was impossible for him to do without more legislation? I refer to the order expanding the distribution of food to the unemployed and giving them more variety in the diet.,THE PRESIDENT. Well, I would not attempt to comment on Mr. Benson. I don't think there's any question of our rights to issue the Executive order under the authority given to us by the Constitution and by legislative action. I think we're within our rights. It is a judgment as to what is the best use to make of the funds that are available--the funds are quite limited. The diet which is being provided for the people who are unemployed is still inadequate. But nevertheless we have used the funds that are available to the maximum. And I don't think there's any question that we were within our rights.,[11] Q. Mr. President, could you tell us how and when you learned that these fliers were going to be released?,THE PRESIDENT. I learned as a result of the conversations which Ambassador Thompson had with the Soviet officials and therefore we were informed as to the date that they would be released--the time-yesterday.,[12.] Q. Mr. President, there has been some apprehension about the instantaneous broadcast of Presidential press conferences such as this one, the contention being that an inadvertent statement no longer correctable, as in the old days, could possibly cause some grave consequences. Do you feel there is any risk or could you give us some thought on that subject?,THE PRESIDENT. Well, it was my understanding that the statements made by the, by President Eisenhower, were on the record. There may have been a clarification that could have been issued afterwards but it still would have demonstrated, it still would have been on the record as a clarification, so that I don't think that the interests of our country are--it seems to me they're as well protected under this system as they were under the system followed by President Eisenhower. And this system has the advantage of providing more direct communication.,[13.] Q. On the question at issue would you consider reopening diplomatic relations with Cuba and are you considering such a step now?,THE PRESIDENT. Well, at the--take the last part first--we are not considering such a step at the present time. I may say that the United States is interested, and l think that this administration is extremely interested in movements in Latin America and Central America, or the Caribbean which provide a better life for the people. And if American interests may be damaged by those movements--or revolutions, or whatever term you want to use--we feel that this should be a matter that should be negotiated. What we are of course concerned about is when these movements are seized by external forces and directed not to improving the welfare of the people involved but towards imposing an ideology which is alien to this hemisphere. That is a matter of concern particularly when that intervention takes the form of military support which threatens the security and the peace of the Western Hemisphere.,Now, I'm hopeful that governments will be established throughout all of Latin America and governments which are established will, and I think nearly all of them do, share the same view that we have to provide in this hemisphere a better life for the people involved, that we are interested in that, that we are concerned about it, that American policy will be directed towards that end. But we are also concerned that in the name of that peaceful revolution, when it's seized by aliens for their purposes, it's very difficult for the United States to carry on happy relations with those countries.,So in answer to your question we have no plan at present to resume diplomatic relations with Cuba, because of the factors which are involved in that island.,[14.] Q. You said in the past, sir, that the President should be in the thick of the political battle, and I wondered, sir, if you could tell us what part you're playing in the effort to expand the Rules Committee and whether you feel your domestic program-whether the success of your domestic program in part depends on expanding the Rules Committee?,THE PRESIDENT. Well, the Constitution states that each house shall be the judge of its own rules, and therefore the Speaker of the House, Mr. Rayburn, has been extremely anxious that the House be permitted to settle this matter in its own way.,But it's no secret that--I would strongly believe that the Members of the House should have an opportunity to vote themselves on the programs which we will present. That, I think, is the reason the people selected them to go to the House of Representatives and to the Senate and selected me as President, so that we could present programs and consider programs and vote on programs which are put forward for the benefit of the country.,Now I feel that it would be--I'm hopeful that whatever judgment is made by the Members of the House, that it will permit the Members to vote on these bills. This is a very difficult time in the life of our country. Many controversial measures will be presented which will be in controversy and will be debated. But at the end the majority of the Members of the House, the majority of the Members of the Senate, I hope, will have a chance to exercise their will, and that a small group of men will not attempt to prevent the Members from finally letting their judgments be known.,For example, we have the housing bill which is going to come before the Congress this year. We have an aid-to-education bill. We have legislation which will affect the income of farmers. Shouldn't the Members of the House themselves and not merely the members of the Rules Committee have a chance to vote on those measures? But the responsibility rests with the Members of the House, and I would not attempt in any way to infringe upon that responsibility. I merely give my view as an interested citizen. [Laughter],[15.] Q. Are any plans being made to implement the recommendations in the Voorhees report on the Cuban refugee problem? Secondly, do you plan to appoint somebody to continue Mr. Voorhees' work?,THE PRESIDENT. We are considering the recommendations of Mr. Voorhees and the whole problem of the Cuban refugees, but I don't have any statement to make on it at this time.,[16.] Q. Mr. President, what is the official Government position in regard to the Portuguese-seized ship? Can the Navy board it if and when it makes contact?,THE PRESIDENT. Well, I believe that the location of the ship has been determined, and--[aside to Mr. Salinger]--perhaps we could give the location of it--at the present time the instructions are for the Navy to continue its accompaniment of the ship. The Santa Maria has been located by Navy P2V aircraft, and the position is approximately 600 miles north of the mouth of the Amazon River. It is headed on a course of 117, a speed of 15 knots, and the exact position at 10 minutes after 4 was 10-35 north, 45-42 west. It will be trailed by aircraft and picked up by the destroyers of our African task force.,Now, there are Americans involved; and their lives are involved. But we have not given any instructions to the Navy to carry out any boarding operations. Though, of course, we are concerned about the lives of the Americans involved. And also we are concerned because the ship belongs to a country with which the United States has friendly relations.,[17.] Q. Mr. President, in consequence of Mr. Khrushchev's apparent indication last weekend of willingness to release the American fliers, have you sent any communication to him through Ambassador Thompson or otherwise?,THE PRESIDENT. Well--have I sent a message since the release of the fliers?,Q. Since his communication to us through Ambassador--,THE PRESIDENT. We have had several exchanges with the Soviet authorities. I do not believe that one has taken place since the release of the prisoners but that's partially because there has been this delay about their leaving Moscow.,[18.] Q. Mr. President, there is meeting here now a nationwide group of labor, agriculture, and industry which wants to abolish all restraints of the Reciprocal Trade Agreements Act. They say that it robs us of gold, robs American workers of jobs. What is your position on such a proposal?,THE PRESIDENT. Well, I think that their meeting here is well within their rights as citizens of the United States and I think that we should listen to their views. This is a matter of great concern. I do think we should be conscious of the fact, of course, that the balance of trade has been substantially in our favor in the last year. But we are continually concerned about those imports which adversely affect an entire industry, or adversely affect the employment of a substantial number of our citizens. The present laws--peril-point and escape clause-of course, all take those matters into consideration. But I'm glad to have them here; I'm glad to have them express their views. I think the Congress should consider their views carefully, and I hope that in their consideration they will consider the whole problem of trade, and I do think we should realize that the balance of trade has been in our favor and the gold flow would have been substantially worse if we had not had this favorable balance of trade.,[19.] Q. Mr. President, in relation to the gold problem, the outgoing administration has ordered a cutback in the number of American military and civilian dependents stationed abroad in the so-called hard currency nations. The day before your inaugural the outgoing Defense Secretary advised your incoming Defense Secretary in a manner urging that relief should be sought as soon as possible because of what the outgoing Defense Secretary termed the "adverse affect of the order on the morale of the military." Have you had a chance to make up your mind on that position, sir?,THE PRESIDENT. Mr. McNamara and Mr. Dillon have discussed the effect of this order on military morale, military strength, the rate of reenlistment. It's really a question of determining what alternative steps can be secured which would be less harmful but which would protect the flow of gold. 'I do expect to make some reference to this matter of gold outflow in the State of the Union Address. I will send within a 2-week period after the State of the Union Address a message to the Congress dealing with the gold outflow and our recommendations for meeting it and we will at that time come to some judgment as to whether a more satisfactory method of protecting our gold could be secured than providing for the return of the families of Americans serving abroad in the military.,I will say that our study so far has convinced us that the dollar must be protected, that the dollar can be protected at its present value, that exchange controls are not essential, but it is a most serious problem and it will be the subject of a message to the Congress.,[20.] Q. Mr. President, the State of New York gave you one of your handsomest majorities in the 1960 election campaign, but now the Democrats of New York are rather bitterly divided over leadership. As the leader of the Democratic Party nationally, are you going to take some steps to try and heal the splits in New York?,THE PRESIDENT. Well the people in New York, the Democratic organizations in New York, who are interested in the success of the Democratic Party, they have to make their judgments as to what kind of a party they want to build there. I have asked Mr. Bailey, the new chairman of the Democratic Party, to lend a helping hand in attempting to alleviate some of the distress. [Laughter],[21.] Q. Sir, do you have any plans for quick Federal aid for the unemployed?,THE PRESIDENT. We are going to send a message to the Congress right after the State of the Union Address on what steps we think the Government could profitably take to provide protection for the unemployed and also to stimulate the economy. On the immediate question, I will discuss that in the State of the Union Address on Monday.,[22.] Q. Mr. President, now that the Soviets have released the RB-47 fliers, will you estimate for us the chances of you meeting with Premier Khrushchev?,THE PRESIDENT. Yes. There is no relationship, nor has there been, in the discussion between the two matters. And therefore I have no--there has been no change in my previous statement that there are no plans at the present time for meeting with Mr. Khrushchev.,[23.] Q. Mr. President, will you tolerate the continued abuse of Executive privilege to suppress information which is needed by Congress? For instance, now that you are President, will you direct the USIA to give the Senate Foreign Relations Committee those prestige polls which you urged the previous administration to make available during the campaign?,THE PRESIDENT. Well, let me say that I would have no objection at all to the polls, or at least the results of the polls, being made available. And I'd be delighted to check in and see what we can do about making it available to the Senate Foreign Relations Committee or the House Foreign Relations Committee, if they would like them.,Q. Mr. President, about the abuses regarding the privilege to suppress all sorts of information. What is your position on that?,THE PRESIDENT. Well, that's a statement, really, not completely a question, in,Q. Sir, but you yourself agreed,THE PRESIDENT. That's why I stated that I thought that it would be well to release these polls and that's why I said I'd be glad to release these polls. Now if other matters come up, we'll have to make a judgment whether it is an abuse or whether it is within the constitutional protections given to the Executive, and I would hope that we can within the limits of national security make available information to the press and to the people, and I do think that it would be helpful to release the polls which we discussed last fall.,Q. Mr. President, Press Secretary Salinger said today, indicated today, there might be a need for a tightening of information on national security. Doesn't the policy of deterrence require that the enemy have knowledge of our strength and the ability to carry them out and wouldn't there be a risk of possible miscalculation by tightening up information?,THE PRESIDENT. Well, I think that the enemy is informed of our strength. I think Mr. Salinger in his statement today at lunch indicated his judgment based on his experience so far, that there had been very ample information given so that the enemy can make a determination as to our strength. I am anxious that we have a maximum flow of information but there quite obviously are some matters which involve the security of the United States, and it's a matter on which the press and the Executive should attempt to reach a responsible decision.,I could not make a prediction about what those matters will be, but I think that all of us here are aware that there are some matters which it would not be well to discuss at particular times so that we just have to wait and try to work together and see if we can provide as much information as we can within the limits of national security. I do not believe that the stamp "National Security" should be put on mistakes of the administration which do not involve the national security, and this administration would welcome any time that any member of the press feels that we are artificially invoking that cover. But I must say that I do not hold the view that all matters and all information which is available to the Executive should be made available at all times, and I don't think any member of the press does. So it's a question of trying to work out a solution to a sensitive matter.,[24.] Q. Mr. President, in the past few days the Secretary of State, Dean Rusk, has issued statements--one with your name on it--to the effect that this country wants a return to quiet private diplomacy. Could you give us some idea of the meaning behind this, Mr. President? Are you trying to suggest to Khrushchev that you'd like to resort to this for the time being without offending him or making him go off the cordial path he's on at the present time?,THE PRESIDENT. Would you--the last part of that,Q. Are you trying to suggest to Mr. Khrushchev by the tone of these--by what you're saying in these statements--that you don't want a summit meeting now and you'd like to go through private channels, and trying to do this without offending him or getting him off the cordial path he's on now?,THE PRESIDENT. Well, I would just say-without accepting the question completely as a premise--I would say that the Secretary of State is anxious to explore with interested countries what chance we have of lessening world tension which is--in some areas of the world--is quite high tonight. And therefore there are occasions when traditional exchanges between diplomats and the countries involved are in the national interest. And that, I think, is what Mr. Rusk is directing his attention to. And I'm hopeful that from those more traditional exchanges we can perhaps find greater common ground.,[25.] Q. Sir, do you favor Senator Humphrey's suggestion that we send surplus food to Red China through the U.N. or CARE, or some similar organization?,THE PRESIDENT. Well, I'd say two things: firstly, Red China--the Chinese Communists-are exporting food at the present time, some of it to Africa, some of it going, I think, to Cuba, and therefore that is a factor in their needs for food from abroad.,Secondly, we've had no indication from the Chinese Communists that they would welcome any offer of food. I'm not anxious to offer food if it's regarded merely as a propaganda effort by the United States. If there is a desire for food and a need for food, then the United States would be glad to consider that need, regardless of the source. If people's lives are involved--if there is a desire for food--the United States will consider it carefully. I do say that in this case, however, there are these examples of food being exported during this present time or recent history and, secondly, there has been a rather belligerent attitude expressed towards us in recent days by the Chinese Communists and there is no indication, direct or indirect, private or public, that they would respond favorably to any acts by the United States.,[26.] Q. Mr. President, the task force report on space has been criticized as partisan opinion. There also has been criticism that the report was made without any contact with NASA officials, without any attempt at liaison during the transition period. And there is concern that no one has so far been named to head the agency. Could you comment on these charges, sir?,THE PRESIDENT. Well, I don't--the task force was free to make the kind of report that in their best judgment the events called for. The task force was made up of men of broad experience in this field. I think it was really a blue-ribbon panel. They presented their views. I don't think anyone is suggesting that their views are necessarily in every case the right views. I am hopeful-we have appointed an acting director-and I'm hopeful that before the week is out we will have a director of NASA.,[27.] Q. Mr. President, you have directed your departmental heads to take a new look at the Eisenhower budget. I wonder--with indications that you may have some partial revisions with this budget-can you now say whether you hope or expect to live within the $80,900 million spending figure which your predecessor laid down?,THE PRESIDENT. I would--that study of the budget is now going on and I couldn't give you an answer yet. We haven't finished our study.,[28.] Q. Mr. President, your Inaugural Address was unusual in that you dealt only with America's position in the world. Why, Mr. President, did you limit yourself to this global theme?,THE PRESIDENT. Well, because the issue of war and peace is involved, and the survival of perhaps the planet, possibly our system. And, therefore, this is a matter of primary concern to the people of the United States and the people of the world.,Secondly, I represent a new administration. I think the views of this administration are quite well known to the American people, and will become better known in the next month. I think that we are new, however, on the world scene, and therefore I felt there would be some use in informing countries around the world of our general view on the questions which face the world and divide the world.,[29.] Q. Mr. President, you have spoken of the situation where there are crises in the world now. One of these crises is Laos. Do you have any hope that a political settlement can be negotiated there?,THE PRESIDENT. Well, as you know, the British Government has presented to the Soviet Union--and to the best of my information an answer has not been received by the British--a proposal to reestablish the International Control Commission. We ought to know shortly whether there's any hope that that commission can be reestablished. As to the general view on Laos, this matter is of great concern to us. The United States is anxious that there be established in Laos a peaceful country--an independent country not dominated by either side but concerned with the life of the people within the country.,We are anxious that that situation come forward. And the United States is using its influence to see if that independent country, peaceful country, uncommitted country, can be established under the present very difficult circumstances.,[30] Q. Mr. President, in discussing with the Soviet Union the release of the RB-47 fliers, did we also take up with Mr. Khrushchev the fate of Francis Gary Powers, a U-2 pilot, and the 11 fliers who are missing from the C-130 which was shot down inside Armenia in 1958?,THE PRESIDENT. The matter of the 11 fliers was discussed and Mr. Khrushchev--the Russians rather--have stated that their previous public statements on these fliers represent their view on the matter: that the newspaper--magazine story which was written by an Eastern German does not represent the facts. So that that would--on the matter of Mr. Powers, we have not discussed him at this time because he is in a different category than the fliers that were released. One was an overflight and the other was a flight of a different nature.,Q. Did the Russians ask any quid pro quo or did we make any concessions to them in exchange for the release of these fliers? If not, how do you account for this remarkable turnabout in their relations with us?,THE PRESIDENT. They did not. The statement which I have made is the statement which the United States Government put forward on this matter, which I read to you earlier in regard to overflights. I would not attempt to make a judgment as to why the Soviet Union chose to release them at this time. I did say in my statement that this had removed a serious obstacle in the way of peaceful relations between the Soviet Union and the United States and I would judge that they desired to remove that serious obstacle.,Q. Mr. President, did they accept a reassurance of no more overflights as an exchange?,THE PRESIDENT. It is a fact that I have ordered that the flights not be resumed, which is a continuation of the order given by President Eisenhower in May of this year.1,1 See 1960-61 volume, this series, pp. 440-441.,[31] Q. Mr. President, your own election has stimulated renewed proposals for electoral reform. Do you have any objection to changing the present method of electing Presidents or do you favor any of the proposals?,THE PRESIDENT. Well, I do have some thoughts on it. One, that in the first place, having been through the experience in '56, I think it was, of an attempt to substantially change the electoral college, it's my judgment that no such change can secure the necessary support in the House, the Senate, and in the States of the Union. The area where I do think we perhaps could get some improvement would be in providing that the electors would be bound by the results of the State elections. I think that that is a--would be a useful step forward.,The electors--after all, when the people vote they assume that the votes are going to be cast in a way which reflects the judgment of a majority of the people of the State and therefore I think it would be useful to have that automatic and not set up this independent group who could vote for the candidate who carried the State or not, depending on their own personal views. That would be the first thing.,Secondly, I'm hopeful that the Congress would consider the suggestions made, I think, first by President Theodore Roosevelt and later by Senator Richard Neuberger, of having the National Government participate in the financing of national campaigns, because the present system is not satisfactory. Perhaps it would be useful to go into that in more detail later because I do think it's a most important subject. But I would say for the present that this matter of the electors would be an area where I think we could usefully move.,[32.] Q. Mr. President, on a related subject, without being morbid, have you given any consideration to the problem which President Eisenhower resolved with his Vice President--that is, the problem of the succession in case of injury, illness, or some incapacitation--some agreement with the Vice President such as your predecessor had?,THE PRESIDENT. Yes.. Well, I haven't developed that at this present time, though I do think that President Eisenhower's decision was a good one, and I think it would be a good precedent. Nothing's been done on it as yet, but I think it would be a good matter on which. we could proceed.\nReporter: Thank you, Mr. President.
    ##   Frequency   Timing Intensity Commitment  Urgency
    ## 1  1.950750 28.23740  76.04205   86.97366 331.9719
    ## 2  1.252183 38.69386  61.42841   91.39771 405.8965

# Using `{poldis}` beyond political texts

Although the functions developed in the package consider the theoretical
implications of working with political texts, they prioritize
flexibility and accessibility. This means users can select priorities,
gather topics, and/or measure urgency for various other types of texts.

# Contributing

If you are interested in using `{poldis}`, please do not hesitate to
contribute to the package by opening
[issues](https://github.com/henriquesposito/poldis/issues), asking
[questions](https://github.com/henriquesposito/poldis/discussions), or
proposing [changes](https://github.com/henriquesposito/poldis/pulls).

# Citing

Lastly, if you are using ´{poldis}´, please do not forget to cite us ;)

``` r
citation("poldis")
```

    ## To cite poldis in publications use:
    ## 
    ##   H. Sposito. poldis: Tools for analyzing political discourse. 2021.
    ## 
    ## A BibTeX entry for LaTeX users is
    ## 
    ##   @Manual{,
    ##     title = {poldis: Tools for analyzing political discourse},
    ##     author = {Henrique Sposito},
    ##     year = {2021},
    ##     url = {https://github.com/henriquesposito/poldis},
    ##   }
