\name{readTASSELGBSv2}
\alias{readTASSELGBSv2}
\title{
Import Read Depth and Alignment from TASSEL GBS v2 
}
\description{
This function reads TagTaxaDist and SAM files output by the TASSEL 5 GBS v2
pipeline, and generates a \code{\link{RADdata}} object suitable for downstream
processing for genotype estimation.  It elimintes the need to run the 
DiscoverySNPCallerPluginV2 or the ProductionSNPCallerPluginV2, since 
\pkg{polyRAD} operates on haplotypes rather than SNPs.
}
\usage{
readTASSELGBSv2(tagtaxadistFile, samFile, min.ind.with.reads = 200, 
                min.ind.with.minor.allele = 10, possiblePloidies = list(2),
                taxaPloidy = 2L, contamRate = 0.001, chromosomes = NULL)
}
\arguments{
  \item{tagtaxadistFile}{
File name or path to a tab-delimited text file of read depth generated by the
GetTagTaxaDistFromDBPlugin in TASSEL.
}
  \item{samFile}{
File name or path to the corresponding SAM file containing alignment
information for the same set of tags.  This file is obtained by running the
TagExportToFastqPlugin in TASSEL, followed by alignment using Bowtie2 or BWA.
}
  \item{min.ind.with.reads}{
Integer used for marker filtering.  The minimum number of individuals that must
have read depth above zero for a locus to be retained in the output.
}
  \item{min.ind.with.minor.allele}{
Integer used for marker filtering.  The minimum number of individuals
possessing reads for the minor allele for a locus to be retained in the output.
This value is also passed to the \code{min.ind.with.haplotype} argument of
\code{\link{MergeRareHaplotypes}}.
}
  \item{possiblePloidies}{
A list indicating inheritance modes that might be encountered in the 
dataset.  See \code{\link{RADdata}}.
}
  \item{taxaPloidy}{
A single integer, or an integer vector with one value per taxon, indicating
ploidy.  See \code{\link{RADdata}}.
}
  \item{contamRate}{
A number indicating the expected sample cross-contamination rate.  See
\code{\link{RADdata}}.
}
  \item{chromosomes}{
A character vector of chromosome names, indicating chromosomes to be retained
in the output.  If \code{NULL}, all chromosomes to be retained.  This argument
is intended to be used for reading data in a chromosome-wise fashion in order
to conserve computer memory.
}
}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\value{
A \code{RADdata} object containing read depth and alignment infomation from
the two input files.
}
\references{
TASSEL GBSv2 pipeline: \url{https://bitbucket.org/tasseladmin/tassel-5-source/wiki/Tassel5GBSv2Pipeline}

Bowtie2: \url{https://bowtie-bio.sourceforge.net/bowtie2/index.shtml}

BWA: \url{https://bio-bwa.sourceforge.net/}
}
\author{
Lindsay V. Clark
}
\note{
Sequence tags must be identical in length to be assigned to the same locus by
this function.  This is to prevent errors with 
\code{\link{MergeRareHaplotypes}}.
}

\seealso{
Other data import functions:  \code{\link{readStacks}}, \code{\link{readHMC}},
\code{\link{readTagDigger}}, \code{\link{VCF2RADdata}},
\code{\link{readDArTag}}
}
\examples{
# get files for this example
samfile <- system.file("extdata", "exampleTASSEL_SAM.txt",
                       package = "polyRAD")
ttdfile <- system.file("extdata", "example_TagTaxaDist.txt",
                       package = "polyRAD")

# import data
myrad <- readTASSELGBSv2(ttdfile, samfile, min.ind.with.reads = 8,
                         min.ind.with.minor.allele = 2)
}
\keyword{ file }
