% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLM_Model.R
\name{MLM_Model}
\alias{MLM_Model}
\title{Multinominal Logistic Model}
\usage{
MLM_Model(Data, xvar, yvar)
}
\arguments{
\item{Data}{The name of the Dataset.}

\item{xvar}{X variables.}

\item{yvar}{Y variable.}
}
\value{
The output from  \code{\link{MLM_Model}}.
}
\description{
Multinominal Logistic Model
}
\details{
Multi-nominal model is the generalized form of generalized logistic model and can be define as
\deqn{\pi_{i}^{h} = P(y_{i}^{h} = 1 | \bold{x}_{\bold{i}}^{h})}
where \eqn{h}{h} presents the class labels ("1-of-h") on the basis of an input vector
\eqn{x_j}{x_j}, in our case \eqn{x_j}{x_j} is loan types ("Formal Loan", "Informal Loan", "Both Loan", and "No Loan").  Furthermore,

 \eqn{y_{i}^h =  1}{y_{i}^h =  1}if the weight \bold{w}
  of  \eqn{x_j}{x_j} corresponds to belong a class and  \eqn{y_{i}^h=0}{y_{i}^h=0} otherwise.
  For \eqn{i}{i} \eqn{\in}{\in} \eqn{1,\ldots,h}{1,...,h} and
  the weight vectors \bold{{w}^{i}} corresponds to class \eqn{i}{i}.

We set \eqn{{\bold{{w}}^{h}} = 0} and the parameters to be learned are the weight vectors \bold{{w}^{i}}
for \eqn{i}{i} \eqn{\in}{\in} \eqn{1,\ldots,h-1}{1,...,h-1} . And the class probabilities must satisfy
\deqn{\sum_{i=1}^{h} P(y_{i}^{h} = 1 | \bold{x}_{\bold{i}}^{h}, \bold{w}) = 1.}
}
\examples{
yvar <- c("Loan.Type")
sample_data <- sample_data[c(1:750),]
xvar <- c("sex", "married", "age", "havejob", "educ", "political.afl",
"rural", "region", "fin.intermdiaries", "fin.knowldge", "income")
BchMk.MLM <- MLM_Model(sample_data, c(xvar, "networth"), yvar )
BchMk.MLM$finalModel
BchMk.MLM$Roc$auc
}
