% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior-class.R
\docType{class}
\name{pompp_prior-class}
\alias{pompp_prior-class}
\alias{names,pompp_prior-method}
\alias{$,pompp_prior-method}
\alias{show,pompp_prior-method}
\alias{print,pompp_prior-method}
\alias{print.pompp_prior}
\alias{$<-,pompp_prior-method}
\title{Joint prior class for the pompp package parameters}
\usage{
\S4method{names}{pompp_prior}(x)

\S4method{$}{pompp_prior}(x, name)

\S4method{show}{pompp_prior}(object)

\S4method{print}{pompp_prior}(x, ...)

\method{print}{pompp_prior}(x, ...)

\S4method{$}{pompp_prior}(x, name)

\S4method{$}{pompp_prior}(x, name) <- value
}
\arguments{
\item{x}{The pompp_prior object.}

\item{name}{The requested slot.}

\item{object}{The pompp_prior object.}

\item{...}{Ignored.}

\item{value}{New value.}
}
\value{
\strong{\code{names}}: A character vector with the model parameters
names.

\strong{\code{`$`}}: The requested slot's value.

\strong{\code{`$<-`}}: The new object with the updated slot.
}
\description{
Objects of this class are the joining of independent priors for Beta, Delta
and LambdaStar. They can be used in the \code{fit_pompp} function.
}
\section{Fields}{

\describe{
\item{\code{beta}}{An object of a class which inherits the \code{BetaDeltaPrior} S4
class with the appropriate Beta prior.}

\item{\code{delta}}{An object of a class which inherits the \code{BetaDeltaPrior} S4
class with the appropriate Delta prior.}

\item{\code{lambdaStar}}{An object of a class which inherits the
\code{LambdaStarPrior} S4 class with the appropriate LambdaStar prior.}

\item{\code{marksMean}}{An object of S4 class \code{NormalPrior} with the chosen
prior for the marks mean}

\item{\code{marksPrecision}}{An object of S4 class \code{GammaPrior} with the chosen
prior for the marks precision}
}}

