% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{poolProbs}
\alias{poolProbs}
\title{Probability of contribution of each pool}
\usage{
poolProbs(nPools, vector_np, nSNPs, pError)
}
\arguments{
\item{nPools}{an integer indicating how many pools were used to sequence the
population.}

\item{vector_np}{is a vector where each entry contains the number of diploid
individuals of a given pool. Thus, if a population was sequenced using two
pools, each with 10 individuals, this vector would contain two entries and
both will be 10.}

\item{nSNPs}{an integer indicating how many SNPs exist in the data.}

\item{pError}{an integer representing the value of the error associated with
DNA pooling. This value is related with the unequal pool contribution
towards the total number of reads of a population - the higher the value
the more unequal are the pool contributions.}
}
\value{
a matrix with the probabilities of contribution for each pool. Each
row represents a different pool and each column is a different site.
}
\description{
This function computes the probability of contribution of each pool towards
the total depth of coverage of a single population. If multiple pools where
used to sequence a single population, it is possible that some pools
contribute more than others.
}
\examples{
# probability of contribution at 8 SNPs for 5 pools, each with 10 individuals
poolProbs(nPools = 5, vector_np = rep(10, 5), nSNPs = 8, pError = 50)

}
