% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-size.r
\name{effects_from_means}
\alias{effects_from_means}
\title{Calculate Effect Sizes from Means}
\usage{
effects_from_means(mu1, mu2, mu11, mu22, phi, nstrata = 1, xi = NULL)
}
\arguments{
\item{mu1}{mean response of the patients receiving treatment 1 in the 
random arm. For unstratified design, should be numeric value.
For the stratified design, should be vector of length equal to
number of strata with each entry corresponding to stratum-
specific mean.}

\item{mu2}{mean response of the patients receiving treatment 2 in the 
random arm. For unstratified design, should be numeric value.
For the stratified design, should be vector of length equal to
number of strata with each entry corresponding to stratum-
specific mean.}

\item{mu11}{mean response of the patients choosing treatment 1 in the choice
 arm. For unstratified design, should be numeric value.
For the stratified design, should be vector of length equal to
number of strata with each entry corresponding to stratum-
specific mean.}

\item{mu22}{mean response of the patients choosing treatment 2 in the choice
 arm. For unstratified design, should be numeric value.
For the stratified design, should be vector of length equal to
number of strata with each entry corresponding to stratum-
specific mean.}

\item{phi}{proportion of patients preferring treatment 1. For unstratified 
design, should be numeric value. For the stratified design, 
should be vector of length equal to number of strata with each 
entry corresponding to stratum-specific preference rate. All 
elements should be numeric values between 0 and 1.}

\item{nstrata}{number of strata. Default is 1 (unstratified design).}

\item{xi}{a numeric vector of the proportion of patients in each stratum. 
Length of vector should equal the number of strata in the study and 
sum of vector should be 1. Should only be specified for stratified
design.}
}
\description{
Calculates the preference, selection and treatment effects given the means
of each treatment group in the choice and random arms for the 2-stage 
randomized study.
}
\examples{
effects_from_means(mu1=1, mu2=2, mu11=1.5, mu22=2.5, phi=0.5)
}
\references{
Rucker G (1989). "A two-stage trial design for testing treatment, 
self-selection and treatment preference effects." \emph{Stat Med}, 
\strong{8}(4):477-485. 
(\href{https://pubmed.ncbi.nlm.nih.gov/2727471}{PubMed})
}
