% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attgt_functions.R
\name{did_attgt}
\alias{did_attgt}
\title{Difference-in-differences for ATT(g,t)}
\usage{
did_attgt(gt_data, xformula = ~1, ...)
}
\arguments{
\item{gt_data}{data that is "local" to a particular group-time average
treatment effect}

\item{xformula}{one-sided formula for covariates used in the propensity score
and outcome regression models}

\item{...}{extra function arguments; not used here}
}
\value{
attgt_if
}
\description{
Takes a data.frame and computes for a particular group g
and time period t and computes
an estimate of a group time average treatment effect
and a corresponding influence function using a difference in differences
approach.

The code relies on \code{gt_data} having certain variables defined.
In particular, there should be an \code{id} column (individual identifier),
\code{D} (treated group identifier), \code{period} (time period), \code{name}
(equal to "pre" for pre-treatment periods and equal to "post" for post
treatment periods), \code{Y} (outcome).

In our case, we call \code{two_by_two_subset} which sets up the
data to have this format before the call to \code{did_attgt}.
}
