% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_marker_test.R
\name{magma}
\alias{magma}
\title{Bayesian Multi-marker Analysis of Genomic Annotation (Bayesian MAGMA)}
\usage{
magma(
  stat = NULL,
  sets = NULL,
  method = "magma",
  type = "joint",
  test = "one-sided",
  pi = 0.001,
  nit = 5000,
  nburn = 1000
)
}
\arguments{
\item{stat}{A numeric vector or matrix of summary statistics, where rows represent features and columns represent phenotypes.}

\item{sets}{A list of feature sets (e.g., genes, SNPs) to be analyzed.}

\item{method}{A string specifying the method to use. Options are `"magma"`, `"blr"`, `"bayesC"`, or `"bayesR"`. Default is `"magma"`.}

\item{type}{A string specifying the type of analysis to perform. Options are `"joint"` (default) or `"marginal"`. Only used with `method = "magma"`.}

\item{test}{A string specifying the statistical test. Options are `"one-sided"` (default) or `"two-sided"`. Only used with `method = "magma"`.}

\item{pi}{A numeric value specifying the proportion of non-zero effects. Used for Bayesian methods. Default is `0.001`.}

\item{nit}{An integer specifying the number of iterations for Bayesian methods. Default is `5000`.}

\item{nburn}{An integer specifying the number of burn-in iterations for Bayesian methods. Default is `1000`.}
}
\value{
A data frame or list with analysis results.
}
\description{
This function analyzes feature sets using MAGMA or Bayesian methods for association testing. 
It supports joint or marginal testing, as well as Bayesian linear regression using different 
priors (`bayesC`, `bayesR`).
}
\details{
The function uses either the MAGMA approach for set-based testing or Bayesian linear regression 
to estimate effect sizes and probabilities of association for feature sets. For Bayesian methods, 
a spike-and-slab prior is applied.

The `stat` input must have row names corresponding to feature identifiers. The `sets` input must 
be a named list, where each element corresponds to a feature set.
}
