% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regular_grid.R
\name{add_regular_polygon_grid}
\alias{add_regular_polygon_grid}
\title{Add the rows needed to complete a regular QuadKey polygon grid
derived from the bounding box of the \code{quadkey} column of a data.frame.}
\usage{
add_regular_polygon_grid(data)
}
\arguments{
\item{data}{A data.frame with a \code{quadkey} column.}
}
\value{
A list with three elements:
\itemize{
\item \code{data} A \code{sf} POLYGON data.frame with all the QuadKeys within
the bounding box of the ones provided in the \code{quadkey} column
of the input dataset, and the rest of the original variables.
The columns \code{quadkey} and \code{geometry} are returned for all the grid,
The values of the newly added QuadKeys will be NA
for the rest of the variables.
\item \code{num_rows} The number of columns of the regular grid.
\item \code{num_cols} The number of rows of the regular grid.
}
}
\description{
This function estimates the bounding box of the quadkeys given in the
quadkey column and adds rows to complete the quadkeys and the geometry
needed to create a regular grid.
All other columns for the introduced QuadKeys will be filled with NAs.

For a detailed explanation on how to use this
and other similar \code{quadkeyr} functions,
read the the vignette:
\url{https://docs.ropensci.org/quadkeyr/articles/quadkey_identified_data_to_raster.html}
}
\examples{
\donttest{
# Read the file with the data
path <- paste0(
  system.file("extdata", package = "quadkeyr"),
  "/cityA_2020_04_15_0000.csv"
)
data <- read.csv(path)
data <- format_fb_data(data)

add_regular_polygon_grid(data = data)
}
}
