% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-helpers.R
\name{thin}
\alias{thin}
\alias{thnSpatialPolygons}
\alias{thin.default}
\title{Thin a polygon}
\usage{
thin(
  x,
  tolerance,
  returnDataFrame,
  minCoordsToThin,
  ...,
  verbose = getOption("quickPlot.verbose")
)

thnSpatialPolygons(
  x,
  tolerance = NULL,
  returnDataFrame = FALSE,
  minCoordsToThin = 1e+05,
  maxNumPolygons = getOption("quickPlot.maxNumPolygons", 3000),
  ...,
  verbose = getOption("quickPlot.verbose")
)

\method{thin}{default}(
  x,
  tolerance,
  returnDataFrame,
  minCoordsToThin,
  maxNumPolygons,
  ...,
  verbose = getOption("quickPlot.verbose")
)
}
\arguments{
\item{x}{A \verb{Spatial*} object}

\item{tolerance}{Maximum allowable distance for a point to be removed.}

\item{returnDataFrame}{If \code{TRUE}, this will return a list of 3 elements,
\code{xyOrd}, \code{hole}, and \code{idLength}.
If \code{FALSE} (default), it will return a \code{SpatialPolygons} object.}

\item{minCoordsToThin}{If the number of coordinates is smaller than this number,
then thin will just pass through, though it will take the time required to
calculate how many points there are (which is not \code{NROW(coordinates(x))} for
a \code{SpatialPolygon})}

\item{...}{Passed to methods (e.g., \code{maxNumPolygons})}

\item{verbose}{Numeric or logical. If \code{TRUE} or \verb{>0}, then messages will be
shown. If \code{FALSE} or \code{0}, most messages will be suppressed.}

\item{maxNumPolygons}{For speed, \code{thin} can also simply remove some of the
polygons. This is likely only a reasonable thing to do if there are
a lot of polygons being plotted in a small space. Current default is
taken from \code{options('quickPlot.maxNumPolygons')}, with a message.}
}
\description{
For visualizing, it is sometimes useful to remove points in \verb{Spatial*} objects.
This will change the geometry, so it is not recommended for computation.
This is similar to \code{sf::st_simplify},
but faster (see examples) for large shapefiles, particularly if
\code{returnDataFrame} is \code{TRUE}.
}
\note{
\emph{\code{thin} will not attempt to preserve topology};
it is strictly for making smaller polygons for the (likely) purpose of visualizing more quickly.
}
