% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{steepAscent}
\alias{steepAscent}
\title{steepAscent: Steepest Ascent}
\usage{
steepAscent(factors, response, size = 0.2, steps = 5, data)
}
\arguments{
\item{factors}{List containing vector of factor names (coded) to be included in calculation, first factor is the reference factor.}

\item{response}{A character of response given in data.}

\item{size}{Numeric integer value giving the step size in coded units for the first factor given in factors.
By default size is set to \code{0.2}.}

\item{steps}{Numeric integer value giving the number of steps.
By default step is set to `5`.}

\item{data}{An object of class \code{\link{facDesign.c}}.}
}
\value{
\code{steepAscent} returns an object of class \code{\link{steepAscent.c}}.
}
\description{
\code{steepAscent} is a method to calculate the steepest ascent for a \code{\link{facDesign.c}} object.
}
\examples{
# Example 1
fdo = facDesign(k = 2, centerCube = 5)
fdo$lows(c(170, 150))
fdo$highs(c(230, 250))
fdo$names(c("temperature", "time"))
fdo$unit(c("C", "minutes"))
yield = c(32.79, 24.07, 48.94, 52.49, 38.89, 48.29, 29.68, 46.5, 44.15)
fdo$.response(yield)
fdo$summary()

sao = steepAscent(factors = c("B", "A"), response = "yield", size = 1,
                  data = fdo)
}
\seealso{
\code{\link{optimum}}, \code{\link{desirability}}
}
