#' @name rYWAASB-package
#' @title Simultaneous Selection by Trait and WAASB Index
#' @docType package
#' @author {
#' Ali Arminian <abeyran@gmail.com>
#' }
#' @description
#' \pkg{rYWAASB} performs a new ranking algorithm based on a
#' "Y*WAASB" biplot generated by the 'metan' package which is
#' used in MET(Multi-Environmental Trials).
#' This package effectively distinguishes the top-ranked genotypes
#' based on a given trait (e.g. grain yield or any other trait
#' in agricultural experiments) and the "WAASB" index in the
#' Genotype-by-environment interaction effect studies.
#' Note: Fortunately, this package can impute missing
#' observations and computes them, eliminating any concerns
#' about their presence in the data set. A complete guide
#' may be found at: <https://github.com/abeyran/rYWAASB/issues>
NULL
#'
#'
#' Dataset1: a tibble containing GEN, Trait(here grain yield), `WAASB` and `WAASBY` indexes.
#' @name maize
#' @docType data
#' @usage data(maize)
#' @keywords datasets
#' @format A `data.frame` with 20 observations (genotypes)
#' within rows and columns including the trait (named as `Y`),
#' `WAASB` and `WAASBY` indexes values.
#' \describe{
#' \item{`GEN`}{a character vector saved as factor}
#' \item{`Y`}{a numeric vector}
#' \item{`WAASB`}{a numeric vector}
#' \item{`WAASBY`}{a numeric vector}
#' }
#' The input format of table of data(NA free), here *maize* data,
#' should be as follows:
#'
#' \tabular{rrrr}{
#' **GEN** \tab **Y** \tab **WAASB** \tab **WAASBY**\cr
#'  Dracma \tab 262.22 \tab 0.81 \tab 81.6\cr
#'  DKC6630 \tab 284.04 \tab 2.20 \tab 88.5\cr
#'  NS770 \tab 243.48 \tab 0.33 \tab 71.4\cr
#'    ...
#' }
#'
#' @examples
#' \donttest{
#' library(rYWAASB)
#' data(maize)
#' ranki(maize)
#' bar_plot1(maize)
#' bar_plot2(maize)
#' PCA_biplot(maize)
#' }
NULL

#' Dataset2: a tibble containing GEN, Trait (days to maturity), `WAASB` and `WAASBY` indexes.
#' @name dm
#' @docType data
#' @usage data(dm)
#' @keywords datasets
#' @format A `data.frame` with 13 observations (chickpea genotypes)
#' within rows and columns including the trait i.e. days to maturity (named as `Y`),
#' `WAASB` and `WAASBY` indexes values.
#' \describe{
#' \item{`GEN`}{a character vector saved as factor}
#' \item{`Y`}{a numeric vector}
#' \item{`WAASB`}{a numeric vector}
#' \item{`WAASBY`}{a numeric vector}
#' }
#'
#' @examples
#' \donttest{
#' library(rYWAASB)
#' data(dm)
#' ranki(dm)
#' bar_plot1(dm)
#' bar_plot2(dm)
#' PCA_biplot(dm)
#' }
NULL

#' Dataset3: a tibble containing ENV, GEN, REP factors and
#' GY(grain yield) and HM agronomic traits from the `metan` package.
#' @name data_ge
#' @docType data
#' @usage data(data_ge)
#' @keywords datasets
#' @format A `data.frame` with 420 rows in 5 columns.
#' \describe{
#' \item{`ENV`}{a character vector}
#' \item{`GEN`}{a character vector}
#' \item{`REP`}{a character vector}
#' \item{`GY`}{a numeric vector}
#' \item{`HM`}{a numeric vector}
#' }
#'
#' @examples
#' \donttest{
#' library(rYWAASB)
#' data(data_ge)
#' }
#' @references
#' Olivoto, T., & Lúcio, A.D.C.2020. metan: An R package for
#' multi‐environment trial analysis. Methods in Ecology and Evolution
#' , 11(6), 783-789.
NULL
