% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radmh.R
\name{radmh}
\alias{radmh}
\title{Medical History Analysis Dataset (ADMH)}
\usage{
radmh(
  adsl,
  max_n_mhs = 10L,
  lookup = NULL,
  seed = NULL,
  na_percentage = 0,
  na_vars = list(MHBODSYS = c(NA, 0.1), MHDECOD = c(1234, 0.1)),
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{max_n_mhs}{(\code{integer})\cr Maximum number of MHs per patient. Defaults to 10.}

\item{lookup}{(\code{data.frame})\cr Additional parameters.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{cached}{boolean whether the cached ADMH data \code{cadmh} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radmh} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating a random Medical History Analysis Dataset for a given
Subject-Level Analysis Dataset.
}
\details{
One record per each record in the corresponding SDTM domain.

Keys: \code{STUDYID}, \code{USUBJID}, \code{ASTDTM}, \code{MHSEQ}
}
\examples{
adsl <- radsl(N = 10, study_duration = 2, seed = 1)

admh <- radmh(adsl, seed = 2)
admh
}
