% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParameters.R, R/survEndp.R, R/chronBias.R,
%   R/selBias.R, R/combinedBias.R
\name{getDistributionPars}
\alias{getDistributionPars}
\alias{getDistributionPars,randSeq,missing,survEndp-method}
\alias{getDistributionPars,randSeq,chronBias,survEndp-method}
\alias{getDistributionPars,randSeq,selBias,survEndp-method}
\alias{getDistributionPars,randSeq,combinedBias,survEndp-method}
\alias{getDistributionPars,randSeq,combinedBiasStepTrend,survEndp-method}
\title{Get distribution parameters of a randomization list}
\usage{
getDistributionPars(randSeq, issue, endp)

\S4method{getDistributionPars}{randSeq,missing,survEndp}(randSeq, endp)

\S4method{getDistributionPars}{randSeq,chronBias,survEndp}(randSeq, issue, endp)

\S4method{getDistributionPars}{randSeq,selBias,survEndp}(randSeq, issue, endp)

\S4method{getDistributionPars}{randSeq,combinedBias,survEndp}(randSeq, issue, endp)

\S4method{getDistributionPars}{randSeq,combinedBiasStepTrend,survEndp}(randSeq, issue, endp)
}
\arguments{
\item{randSeq}{object of the class randSeq.}

\item{issue}{object of the class issue (optional).}

\item{endp}{object of the class endpoint.}
}
\value{
a matrix of the distribution parameters of the included
 patients in the clinical trial.
}
\description{
Generates a matrix of the distribution parameters of the included patients
in the clinical trial.
}
\examples{
# return the shape and scale parameters of a Weibull distribution
endp <- survEndp(shape = c(1,1), scale = c(0.5,1), cenTime = 10, cenRate = 0.01)
biasSB <- selBias("CS", log(2), "exact")
randSeq <- genSeq(rpbrPar(rb = 2, N = 12))
getDistributionPars(randSeq,biasSB,endp)
}
