% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getQ.R
\name{getQ}
\alias{getQ}
\title{Calculate Q Matrix}
\usage{
getQ(rankings, I, J)
}
\arguments{
\item{rankings}{A matrix of rankings, potentially with attribute "assignments" to signify separate
reviewer assignments. One ranking per row.}

\item{I}{A numeric entry indicating the total number of judges providing rankings and ratings.}

\item{J}{A numeric entry or vector of positive integers indicating total number of objects.}
}
\value{
A matrix with dimension \code{J} x \code{J}.
}
\description{
This function calculates the Q matrix given a collection of (partial) rankings.
}
\examples{
rankings <- matrix(c(1,2,3,4,2,1,NA,NA),byrow=TRUE,nrow=2)
getQ(rankings=rankings,I=2,J=4)
attr(rankings,"assignments") <- matrix(c(rep(TRUE,7),FALSE),byrow=TRUE,nrow=2,ncol=4)
getQ(rankings=rankings,I=2,J=4)

}
