% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{biasBound_density}
\alias{biasBound_density}
\title{Bias bound approach for density estimation}
\usage{
biasBound_density(
  X,
  x = NULL,
  h = NULL,
  h_method = "cv",
  alpha = 0.05,
  resol = 100,
  xi_lb = NULL,
  xi_ub = NULL,
  methods_get_xi = "Schennach",
  if_plot_density = TRUE,
  if_plot_ft = FALSE,
  ora_Ar = NULL,
  kernel.fun = "Schennach2004",
  if_approx_kernel = TRUE,
  kernel.resol = 1000
)
}
\arguments{
\item{X}{A numerical vector of sample data.}

\item{x}{Optional. A scalar or range of points where the density is estimated. If NULL, a range is automatically generated.}

\item{h}{A scalar bandwidth parameter. If NULL, the bandwidth is automatically selected using the method specified in 'h_method'.}

\item{h_method}{Method for automatic bandwidth selection when h is NULL. Options are "cv" (cross-validation) and "silverman" (Silverman's rule of thumb). Default is "cv".}

\item{alpha}{Confidence level for intervals. Default is 0.05.}

\item{resol}{Resolution for the estimation range. Default is 100.}

\item{xi_lb}{Optional. Lower bound for the interval of Fourier Transform frequency xi. Used for determining the range over which A and r is estimated. If NULL, it is automatically determined based on the methods_get_xi.}

\item{xi_ub}{Optional. Upper bound for the interval of Fourier Transform frequency xi. Similar to xi_lb, it defines the upper range for A and r estimation. If NULL, the upper bound is determined based on the methods_get_xi.}

\item{methods_get_xi}{A string specifying the method to automatically determine the xi interval if xi_lb and xi_ub are NULL. Options are "Schennach" and "Schennach_loose". If "Schennach" the range is selected based on the Theorem 2 in Schennach2020, if "Schennach_loose", it is defined by the initial interval given in Theorem 2 without selecting the xi_n.}

\item{if_plot_density}{Logical. If TRUE, plots the density estimation.}

\item{if_plot_ft}{Logical. If TRUE, plots the Fourier transform.}

\item{ora_Ar}{Optional list of oracle values for A and r.}

\item{kernel.fun}{A string specifying the kernel function to be used. Options are "Schennach2004", "sinc", "normal", "epanechnikov".}

\item{if_approx_kernel}{Logical. If TRUE, uses approximations for the kernel function.}

\item{kernel.resol}{The resolution for kernel function approximation. See \code{\link{fun_approx}}.}
}
\value{
A list containing various outputs including estimated values, plots, and intervals.
}
\description{
Estimates the density at a given point or across a range, and provides visualization options for density,
bias, and confidence intervals.
}
\examples{
\donttest{
# Example 1: Specifying x for point estimation with manually selected xi range
# from a fixed bandwidth
biasBound_density(
  X = sample_data$X,
  x = 1,
  h = 0.09,
  xi_lb = 1,
  xi_ub = 12,
  if_plot_ft = TRUE,
  kernel.fun = "Schennach2004"
)

# Example 2: Density estimation with automatic bandwidth selection using cross-validation
# biasBound_density(
#   X = sample_data$X,
#   h = NULL,
#   h_method = "cv",
#   xi_lb = 1,
#   xi_ub = 12,
#   if_plot_ft = FALSE,
#   kernel.fun = "Schennach2004"
# )

# Example 3: Density estimation with automatic bandwidth selection using Silverman's rule
#  biasBound_density(
#   X = sample_data$X,
#   h = NULL,
#   h_method = "silverman",
#   methods_get_xi = "Schennach",
#   if_plot_ft = TRUE,
#   kernel.fun = "Schennach2004"
# )
}
}
