% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_bayes.R
\name{sd_Bayes}
\alias{sd_Bayes}
\title{Create Stan file for Bayesian inference}
\usage{
sd_Bayes(
  filepath,
  meas_mdl,
  estimated_params,
  data_params = NULL,
  data_inits = NULL,
  const_list = NULL,
  forecast = FALSE
)
}
\arguments{
\item{filepath}{A string that indicates a path to a file with extension .stmx
or .xmile. Vensim files (.mdl) are not xmile files. They must be exported
from Vensim with extension .xmile}

\item{meas_mdl}{A list of strings. Each string corresponds to a sampling
statement written in Stan language.}

\item{estimated_params}{A list of lists. Each sublist describes each
parameter that will be estimated in the inference stage. To construct this
description, the user can avail of the function `sd_prior`.}

\item{data_params}{An optional string vector defining which model
parameters will be configured through the Stan data block. That is, the
user will provide fixed values for such parameters at every Stan run.}

\item{data_inits}{An optional string vector defining which model
parameters that \strong{only affect initial values} (of stocks) will be
configured through the Stan data block. That is, the user will provide fixed
values for such parameters at every Stan run.}

\item{const_list}{A list in which each element's name is the name of the
constant to override and the element's value correspond to the new value.}

\item{forecast}{An optional boolean that indicates whether the Stan file
supports a forecast. If \code{TRUE}, the \strong{data} block requires the
user to supply an integer value for \code{n_fcst}. This variable corresponds
to the number of periods that will be predicted.}
}
\value{
A string
}
\description{
Create Stan file for Bayesian inference
}
\section{Negative binomial measurement component}{


While this package aims to avoid making decisions for users whenever
possible, I have taken the liberty to automate the transformation of phi
(the concentration parameter) when using the Negative Binomial distribution
(\href{https://mc-stan.org/docs/functions-reference/nbalt.html}{alternative parameterisation})
as a measurement component. \code{sd_Bayes()} automatically creates an
inverse phi parameter for computational efficiency, which will be subject to
inference (instead of phi). Additionally, I have provided a default prior for
this inv_phi but users can override it as needed.
}

\section{Time}{


Simulation of the ordinary differential equation (ODE) model starts at time 0.
}

\examples{
  filepath         <- system.file("models/", "SEIR.stmx", package = "readsdr")
  mm1              <- "y ~ neg_binomial_2(net_flow(C), phi)"
  meas_mdl         <- list(mm1)
  estimated_params <- list(
    sd_prior("par_beta", "lognormal", c(0, 1)),
    sd_prior("par_rho", "beta", c(2, 2)),
    sd_prior("I0", "lognormal", c(0, 1), "init"))
  sd_Bayes(filepath, meas_mdl, estimated_params)
}
