% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik_fun.R
\name{sd_loglik_fun}
\alias{sd_loglik_fun}
\title{Generate a log-likelihood function for an SD model}
\usage{
sd_loglik_fun(
  filepath,
  unknown_pars,
  meas_data_mdl,
  neg_log = FALSE,
  supplied_pars = NULL,
  start_time = NULL,
  stop_time = NULL,
  timestep = NULL,
  integ_method = "euler",
  const_list = NULL
)
}
\arguments{
\item{filepath}{A string that indicates a path to a file with extension .stmx
or .xmile. Vensim files (.mdl) are not xmile files. They must be exported
from Vensim with extension .xmile}

\item{unknown_pars}{A list of lists. Each second-level list contains at least
the element name \code{name}, which corresponds to the parameter's name
subject to estimation. In addition to the element \code{name}, users can
incorporate in the sub-list the elements \code{min} and \code{max}. The
value of \code{min} can only be \code{0}, whereas the value of \code{max}
 can only be \code{1}.}

\item{meas_data_mdl}{A list of lists. Each second-level list corresponds to
a sampling statement along with its measurements. Here is an example: \cr
\code{list(formula      = "y ~ neg_binomial_2(net_flow(C), phi)",
           measurements = 1:10))}}

\item{neg_log}{A boolean that indicates whether the log-likelihood function
returns a positive or negative value. If \code{TRUE}, the function
returns a positive value (for minimisation optimisers). If
\code{FALSE}, the function returns the original log-likelihood.}

\item{supplied_pars}{A string vector indicating the name of parameters whose
values will be supplied to the function. These values will not be subject to
optimisation.}

\item{start_time}{A number indicating the time at which the simulation begins.}

\item{stop_time}{A number indicating the time at which the simulation ends.}

\item{timestep}{A number indicating the time interval for the simulation.
Also known as \code{dt}.}

\item{integ_method}{A string indicating the integration method. It can be
either "euler" or "rk4"}

\item{const_list}{A list in which each element's name is the name of the
constant to override and the element's value correspond to the new value.}
}
\value{
A list of three elements. The first element, \code{fun}, corresponds
to the log likelihood function. The second element, \code{par_names},
indicates the order in which the unknowns are returned. The third element,
\code{sim_params}, corresponds to the simulation parameters (start time,
stop time, and the integration step or dt) employed by the solver function.
}
\description{
Generate a log-likelihood function for an SD model
}
\examples{
 filepath      <- system.file("models/", "SEIR.stmx", package = "readsdr")
 unknown_pars  <- list(list(par_name = "par_beta", min = 0))
 meas_data_mdl <- list(list(formula      = "y ~ neg_binomial_2(net_flow(C), phi)",
                            measurements = 1:10))
 fun_obj <- sd_loglik_fun(filepath, unknown_pars, meas_data_mdl, neg_log = FALSE,
                          start_time = 0, stop_time = 10, timestep = 1/32)
}
