% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoxCox.R, R/YeoJohnson.R, R/arrange.R,
%   R/bin2factor.R, R/bs.R, R/center.R, R/class.R, R/classdist.R,
%   R/classdist_shrunken.R, R/colcheck.R, R/corr.R, R/count.R, R/cut.R,
%   R/date.R, R/depth.R, R/discretize.R, R/dummy.R, R/dummy_extract.R,
%   R/dummy_multi_choice.R, R/factor2string.R, R/filter.R, R/filter_missing.R,
%   R/geodist.R, R/harmonic.R, R/holiday.R, R/hyperbolic.R, R/ica.R,
%   R/impute_bag.R, R/impute_knn.R, R/impute_linear.R, R/impute_lower.R,
%   R/impute_mean.R, R/impute_median.R, R/impute_mode.R, R/impute_roll.R,
%   R/indicate_na.R, R/integer.R, R/interact.R, R/intercept.R, R/inverse.R,
%   R/invlogit.R, R/isomap.R, R/kpca.R, R/kpca_poly.R, R/kpca_rbf.R, R/lag.R,
%   R/lincomb.R, R/log.R, R/logit.R, R/missing.R, R/mutate.R, R/mutate_at.R,
%   R/naomit.R, R/newvalues.R, R/nnmf.R, R/nnmf_sparse.R, R/normalize.R,
%   R/novel.R, R/ns.R, R/num2factor.R, R/nzv.R, R/ordinalscore.R, R/other.R,
%   R/pca.R, R/percentile.R, R/pls.R, R/poly.R, R/poly_bernstein.R, R/profile.R,
%   R/range.R, R/range_check.R, R/ratio.R, R/regex.R, R/relevel.R, R/relu.R,
%   R/rename.R, R/rename_at.R, R/rm.R, R/sample.R, R/scale.R, R/select.R,
%   R/shuffle.R, R/slice.R, R/spatialsign.R, R/spline_b.R, R/spline_convex.R,
%   R/spline_monotone.R, R/spline_natural.R, R/spline_nonnegative.R, R/sqrt.R,
%   R/string2factor.R, R/tidy.R, R/time.R, R/unknown.R, R/unorder.R, R/window.R,
%   R/zv.R
\name{tidy.step_BoxCox}
\alias{tidy.step_BoxCox}
\alias{tidy.step_YeoJohnson}
\alias{tidy.step_arrange}
\alias{tidy.step_bin2factor}
\alias{tidy.step_bs}
\alias{tidy.step_center}
\alias{tidy.check_class}
\alias{tidy.step_classdist}
\alias{tidy.step_classdist_shrunken}
\alias{tidy.check_cols}
\alias{tidy.step_corr}
\alias{tidy.step_count}
\alias{tidy.step_cut}
\alias{tidy.step_date}
\alias{tidy.step_depth}
\alias{tidy.step_discretize}
\alias{tidy.step_dummy}
\alias{tidy.step_dummy_extract}
\alias{tidy.step_dummy_multi_choice}
\alias{tidy.step_factor2string}
\alias{tidy.step_filter}
\alias{tidy.step_filter_missing}
\alias{tidy.step_geodist}
\alias{tidy.step_harmonic}
\alias{tidy.step_holiday}
\alias{tidy.step_hyperbolic}
\alias{tidy.step_ica}
\alias{tidy.step_impute_bag}
\alias{tidy.step_impute_knn}
\alias{tidy.step_impute_linear}
\alias{tidy.step_impute_lower}
\alias{tidy.step_impute_mean}
\alias{tidy.step_impute_median}
\alias{tidy.step_impute_mode}
\alias{tidy.step_impute_roll}
\alias{tidy.step_indicate_na}
\alias{tidy.step_integer}
\alias{tidy.step_interact}
\alias{tidy.step_intercept}
\alias{tidy.step_inverse}
\alias{tidy.step_invlogit}
\alias{tidy.step_isomap}
\alias{tidy.step_kpca}
\alias{tidy.step_kpca_poly}
\alias{tidy.step_kpca_rbf}
\alias{tidy.step_lag}
\alias{tidy.step_lincomb}
\alias{tidy.step_log}
\alias{tidy.step_logit}
\alias{tidy.check_missing}
\alias{tidy.step_mutate}
\alias{tidy.step_mutate_at}
\alias{tidy.step_naomit}
\alias{tidy.check_new_values}
\alias{tidy.step_nnmf}
\alias{tidy.step_nnmf_sparse}
\alias{tidy.step_normalize}
\alias{tidy.step_novel}
\alias{tidy.step_ns}
\alias{tidy.step_num2factor}
\alias{tidy.step_nzv}
\alias{tidy.step_ordinalscore}
\alias{tidy.step_other}
\alias{tidy.step_pca}
\alias{tidy.step_percentile}
\alias{tidy.step_pls}
\alias{tidy.step_poly}
\alias{tidy.step_poly_bernstein}
\alias{tidy.step_profile}
\alias{tidy.step_range}
\alias{tidy.check_range}
\alias{tidy.step_ratio}
\alias{tidy.step_regex}
\alias{tidy.step_relevel}
\alias{tidy.step_relu}
\alias{tidy.step_rename}
\alias{tidy.step_rename_at}
\alias{tidy.step_rm}
\alias{tidy.step_sample}
\alias{tidy.step_scale}
\alias{tidy.step_select}
\alias{tidy.step_shuffle}
\alias{tidy.step_slice}
\alias{tidy.step_spatialsign}
\alias{tidy.step_spline_b}
\alias{tidy.step_spline_convex}
\alias{tidy.step_spline_monotone}
\alias{tidy.step_spline_natural}
\alias{tidy.step_spline_nonnegative}
\alias{tidy.step_sqrt}
\alias{tidy.step_string2factor}
\alias{tidy.recipe}
\alias{tidy.step}
\alias{tidy.check}
\alias{tidy.step_time}
\alias{tidy.step_unknown}
\alias{tidy.step_unorder}
\alias{tidy.step_window}
\alias{tidy.step_zv}
\title{Tidy the result of a recipe}
\usage{
\method{tidy}{step_BoxCox}(x, ...)

\method{tidy}{step_YeoJohnson}(x, ...)

\method{tidy}{step_arrange}(x, ...)

\method{tidy}{step_bin2factor}(x, ...)

\method{tidy}{step_bs}(x, ...)

\method{tidy}{step_center}(x, ...)

\method{tidy}{check_class}(x, ...)

\method{tidy}{step_classdist}(x, ...)

\method{tidy}{step_classdist_shrunken}(x, ...)

\method{tidy}{check_cols}(x, ...)

\method{tidy}{step_corr}(x, ...)

\method{tidy}{step_count}(x, ...)

\method{tidy}{step_cut}(x, ...)

\method{tidy}{step_date}(x, ...)

\method{tidy}{step_depth}(x, ...)

\method{tidy}{step_discretize}(x, ...)

\method{tidy}{step_dummy}(x, ...)

\method{tidy}{step_dummy_extract}(x, ...)

\method{tidy}{step_dummy_multi_choice}(x, ...)

\method{tidy}{step_factor2string}(x, ...)

\method{tidy}{step_filter}(x, ...)

\method{tidy}{step_filter_missing}(x, ...)

\method{tidy}{step_geodist}(x, ...)

\method{tidy}{step_harmonic}(x, ...)

\method{tidy}{step_holiday}(x, ...)

\method{tidy}{step_hyperbolic}(x, ...)

\method{tidy}{step_ica}(x, ...)

\method{tidy}{step_impute_bag}(x, ...)

\method{tidy}{step_impute_knn}(x, ...)

\method{tidy}{step_impute_linear}(x, ...)

\method{tidy}{step_impute_lower}(x, ...)

\method{tidy}{step_impute_mean}(x, ...)

\method{tidy}{step_impute_median}(x, ...)

\method{tidy}{step_impute_mode}(x, ...)

\method{tidy}{step_impute_roll}(x, ...)

\method{tidy}{step_indicate_na}(x, ...)

\method{tidy}{step_integer}(x, ...)

\method{tidy}{step_interact}(x, ...)

\method{tidy}{step_intercept}(x, ...)

\method{tidy}{step_inverse}(x, ...)

\method{tidy}{step_invlogit}(x, ...)

\method{tidy}{step_isomap}(x, ...)

\method{tidy}{step_kpca}(x, ...)

\method{tidy}{step_kpca_poly}(x, ...)

\method{tidy}{step_kpca_rbf}(x, ...)

\method{tidy}{step_lag}(x, ...)

\method{tidy}{step_lincomb}(x, ...)

\method{tidy}{step_log}(x, ...)

\method{tidy}{step_logit}(x, ...)

\method{tidy}{check_missing}(x, ...)

\method{tidy}{step_mutate}(x, ...)

\method{tidy}{step_mutate_at}(x, ...)

\method{tidy}{step_naomit}(x, ...)

\method{tidy}{check_new_values}(x, ...)

\method{tidy}{step_nnmf}(x, ...)

\method{tidy}{step_nnmf_sparse}(x, ...)

\method{tidy}{step_normalize}(x, ...)

\method{tidy}{step_novel}(x, ...)

\method{tidy}{step_ns}(x, ...)

\method{tidy}{step_num2factor}(x, ...)

\method{tidy}{step_nzv}(x, ...)

\method{tidy}{step_ordinalscore}(x, ...)

\method{tidy}{step_other}(x, ...)

\method{tidy}{step_pca}(x, type = "coef", ...)

\method{tidy}{step_percentile}(x, ...)

\method{tidy}{step_pls}(x, ...)

\method{tidy}{step_poly}(x, ...)

\method{tidy}{step_poly_bernstein}(x, ...)

\method{tidy}{step_profile}(x, ...)

\method{tidy}{step_range}(x, ...)

\method{tidy}{check_range}(x, ...)

\method{tidy}{step_ratio}(x, ...)

\method{tidy}{step_regex}(x, ...)

\method{tidy}{step_relevel}(x, ...)

\method{tidy}{step_relu}(x, ...)

\method{tidy}{step_rename}(x, ...)

\method{tidy}{step_rename_at}(x, ...)

\method{tidy}{step_rm}(x, ...)

\method{tidy}{step_sample}(x, ...)

\method{tidy}{step_scale}(x, ...)

\method{tidy}{step_select}(x, ...)

\method{tidy}{step_shuffle}(x, ...)

\method{tidy}{step_slice}(x, ...)

\method{tidy}{step_spatialsign}(x, ...)

\method{tidy}{step_spline_b}(x, ...)

\method{tidy}{step_spline_convex}(x, ...)

\method{tidy}{step_spline_monotone}(x, ...)

\method{tidy}{step_spline_natural}(x, ...)

\method{tidy}{step_spline_nonnegative}(x, ...)

\method{tidy}{step_sqrt}(x, ...)

\method{tidy}{step_string2factor}(x, ...)

\method{tidy}{recipe}(x, number = NA, id = NA, ...)

\method{tidy}{step}(x, ...)

\method{tidy}{check}(x, ...)

\method{tidy}{step_time}(x, ...)

\method{tidy}{step_unknown}(x, ...)

\method{tidy}{step_unorder}(x, ...)

\method{tidy}{step_window}(x, ...)

\method{tidy}{step_zv}(x, ...)
}
\arguments{
\item{x}{A \code{recipe} object, step, or check (trained or otherwise).}

\item{...}{Not currently used.}

\item{type}{For \code{step_pca}, either \code{"coef"} (for the variable loadings per
component) or \code{"variance"} (how much variance does each component
account for).}

\item{number}{An integer or \code{NA}. If missing, and \code{id} is not provided, the
return value is a list of the operations in the recipe. If a number is
given, a \code{tidy} method is executed for that operation in the recipe (if it
exists). \code{number} must not be provided if \code{id} is.}

\item{id}{A character string or \code{NA}. If missing and \code{number} is not
provided, the return value is a list of the operations in the recipe. If a
character string is given, a \code{tidy} method is executed for that operation
in the recipe (if it exists). \code{id} must not be provided if \code{number} is.}
}
\value{
A tibble with columns that vary depending on what \code{tidy} method is
executed. When \code{number}, and \code{id} are \code{NA}, a tibble with columns \code{number}
(the operation iteration), \code{operation} (either "step" or "check"), \code{type}
(the method, e.g. "nzv", "center"), a logical column called \code{trained} for
whether the operation has been estimated using \code{prep}, a logical for
\code{skip}, and a character column \code{id}.
}
\description{
\code{tidy()} will return a data frame that contains information regarding a
recipe or operation within the recipe (when a \code{tidy()} method for the
operation exists).
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sacramento, package = "modeldata")

Sacramento_rec <- recipe(~., data = Sacramento) |>
  step_other(all_nominal(), threshold = 0.05, other = "another") |>
  step_center(all_numeric()) |>
  step_dummy(all_nominal()) |>
  check_cols(ends_with("ude"), sqft, price)

tidy(Sacramento_rec)

tidy(Sacramento_rec, number = 2)
tidy(Sacramento_rec, number = 3)

Sacramento_rec_trained <- prep(Sacramento_rec, training = Sacramento)

tidy(Sacramento_rec_trained)
tidy(Sacramento_rec_trained, number = 3)
tidy(Sacramento_rec_trained, number = 4)
\dontshow{\}) # examplesIf}
}
