% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editLayers.R
\name{editLayers}
\alias{editLayers}
\title{Edit multiple color patches using morphological operations}
\usage{
editLayers(
  recolorize_obj,
  layer_idx = "all",
  operations = "clean",
  px_sizes = 2,
  plotting = TRUE
)
}
\arguments{
\item{recolorize_obj}{A recolorize object from \code{\link[=recolorize]{recolorize()}},
\code{\link[=recluster]{recluster()}}, or \code{\link[=imposeColors]{imposeColors()}}.}

\item{layer_idx}{A numeric vector of layer indices to be edited, or \code{"all"}
(in which case all layers are edited). Corresponds to the order of the
colors in the \code{centers} attribute of the recolorize object, and to the
indices in the \code{pixel_assignments} attribute of the same.}

\item{operations}{Either a single string OR a character vector of imager
morphological operation(s) to perform on the specified layer(s). If this is
shorter than \code{layer_idx}, it is repeated to match the length of
\code{layer_idx}.}

\item{px_sizes}{The size(s) (in pixels) of the elements to filter. Either a
single number OR a numeric vector. If shorter than \code{layer_idx}, it is
repeated to match the length of \code{layer_idx}. If \code{operation = "shrink"} and
\code{px_size = 2}, for example, the color patch will be shrunk by a 2-pixel
radius.}

\item{plotting}{Logical. Plot results?}
}
\value{
A \code{recolorize} object. The \code{sizes}, \verb{pixel_assignments,}, and
\code{recolored_img} attributes will differ from the input object for the
relevant color patches (layers) to reflect their changes.
}
\description{
A wrapper for \link{editLayer}, allowing for multiple layers
to be edited at once, either with the same morphological operation
or specified for each layer.
}
\details{
Current imager operations are:
\itemize{
\item \code{\link[imager:grow]{imager::grow()}}: Grow a pixset
\item \code{\link[imager:grow]{imager::shrink()}}: Shrink a pixset
\item \code{\link[imager:clean]{imager::fill()}}: Remove holes in an pixset. Accomplished by
growing and then shrinking a pixset.
\item \code{\link[imager:clean]{imager::clean()}}: Remove small isolated elements (speckle).
Accomplished by shrinking and then growing a pixset.
}
}
\examples{
# load image and recolorize it
img <- system.file("extdata/corbetti.png", package = "recolorize")

# first do a standard color binning
init_fit <- recolorize(img, bins = 2, plotting = FALSE)

# then cluster patches by similarity
re_fit <- recluster(init_fit, cutoff = 40)

# to reset graphical parameters:
current_par <- graphics::par(no.readonly = TRUE)

# examine individual layers:
layout(matrix(1:6, nrow = 2))
layers <- splitByColor(re_fit, plot_method = "color")

# we can clean them all using the same parameters...
edited_fit <- editLayers(re_fit, layer_idx = "all",
                         operations = "clean",
                         px_sizes = 2, plotting = TRUE)
# ...but some of those patches don't look so good

# we can use different px_sizes for each layer:
edited_fit_2 <- editLayers(re_fit, layer_idx = "all",
                           operations = "clean",
                           px_sizes = c(1, 3, 1,
                                        2, 1, 2),
                           plotting = TRUE)

# better yet, we can fill some layers and clean others:
edited_fit_3 <- editLayers(re_fit, layer_idx = "all",
                           operations = c("fill", "clean",
                                          "fill", "fill",
                                          "fill", "clean"),
                           px_sizes = c(2, 3,
                                        2, 2,
                                        4, 2))

# or you could just get weird:
edited_fit_3 <- editLayers(re_fit, layer_idx = c(1:6),
                           operations = c("fill", "clean"),
                           px_sizes = c(10, 20))

# reset graphical parameters:
graphics::par(current_par)

}
\seealso{
\link{editLayer} for editing a single layer at a time.
}
