% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readImage.R
\name{readImage}
\alias{readImage}
\title{Read in an image as a 3D array}
\usage{
readImage(img_path, resize = NULL, rotate = NULL)
}
\arguments{
\item{img_path}{Path to the image (a string).}

\item{resize}{Fraction by which to reduce image size. Important for speed.}

\item{rotate}{Number of degrees to rotate the image.}
}
\value{
A 3D RGB array (pixel rows x pixel columns x color channels). RGB channels
are all scaled 0-1, not 0-255.
}
\description{
Reads in and processes an image as a 3D array. Extremely simple wrapper for
\code{\link[imager:load.image]{imager::load.image()}}, but it strips the depth channel (resulting
in a 3D, not 4D, array). This will probably change.
}
\examples{
corbetti <- system.file("extdata/corbetti.png", package = "recolorize")
img <- readImage(corbetti)
plotImageArray(img)

}
