% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restopt_problem.R
\name{get_aggregation_method}
\alias{get_aggregation_method}
\title{Retrieve the aggregation method of a restopt problem.}
\usage{
get_aggregation_method(problem)
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}
}
\value{
\code{character} The aggregation method of the restopt problem.
}
\description{
Retrieve the aggregation method of a restopt problem.
}
\examples{
\dontrun{
#' # load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

# create problem
problem <- restopt_problem(
       existing_habitat = habitat_data,
       aggregation_factor = 4,
       habitat_threshold = 0.7,
       lossless_aggregation = TRUE
)

get_aggregation_method(problem)
}

}
