% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wsola.R
\name{wsola}
\alias{wsola}
\title{wsola}
\usage{
wsola(x, s, win = "hann", winLen = 1024, synHop = 512, tol = 512)
}
\arguments{
\item{x}{an audio signal}

\item{s}{a scaling factor or a list of two vector with anchor points}

\item{win}{window function. Default is 'hann' for hanning window. Can also be a custom window supplied as a vector}

\item{winLen}{window length}

\item{synHop}{synthesis window hop size}

\item{tol}{tolerance for overlap delta}
}
\value{
retimed audio signal as vector
}
\description{
Waveform Similarity Overlap-add. Translated from 'TSM Toolbox'.
}
\examples{
set.seed(42)
data(mm1)
dur <- length(mm1)
n <- 10
x <- runif(n)
anchors <- list(anc_in = c(0, dur*seq_len(n)/n),
                anc_out = c(0, dur*cumsum(x)/sum(x)))
sig <- wsola(mm1@left, anchors)
}
\references{
Driedger, J., Müller, M. (2014). TSM Toolbox: MATLAB Implementations of Time-Scale Modification Algorithms. In Proceedings of the International Conference on Digital Audio Effects (DAFx): 249–256.
}
\seealso{
fft_spectrum, get_serials_anchors
}
