% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proptesti.R
\name{proptesti}
\alias{proptesti}
\alias{proptesti.do}
\alias{print.proptesti}
\alias{proptesti.default}
\title{Test of proportions from summary statistics}
\usage{
proptesti(
  x1,
  n1,
  x2 = NULL,
  n2 = NULL,
  exact = FALSE,
  null.hypoth = ifelse(is.null(x2) && is.null(n2), 0.5, 0),
  conf.level = 0.95,
  alternative = "two.sided",
  correct = FALSE,
  more.digits = 0
)
}
\arguments{
\item{x1}{Number of successes in first sample}

\item{n1}{Number of trials in first sample}

\item{x2}{Number of successes in second sample}

\item{n2}{Number of trials in second sample}

\item{exact}{If true, performs a
test of equality of proportions with Exact Binomial based confidence
intervals.}

\item{null.hypoth}{a number specifying the
null hypothesis for the mean (or difference in means if performing a
two-sample test). Defaults to 0.5 for one-sample and 0 for two-sample.}

\item{conf.level}{confidence level of the
test. Defaults to 0.95}

\item{alternative}{a string: one of
\code{"less"}, \code{"two.sided"}, or \code{"greater"} specifying the form
of the test. Defaults to a two-sided test. When either \code{"less"} or \code{"greater"} is 
used, the corresponding one-sided confidence interval is returned.}

\item{correct}{a logical indicating whether to perform a continuity correction}

\item{more.digits}{a numeric value
specifying whether or not to display more or fewer digits in the output.
Non-integers are automatically rounded down.}
}
\value{
A list of class \code{proptesti}. The print method lays out the information in an easy-to-read
format. 
\describe{
\item{tab}{A formatted table of descriptive and inferential results (total number of observations,
sample proportion, standard error of the proportion estimate), 
along with a confidence interval for the underlying proportion.}
\item{zstat}{the value of the test
statistic, if using an approximate test.} 
\item{pval}{the p-value
for the test} 
\item{par}{A vector of information about the type of test (null hypothesis, alternative hypothesis, etc.)}
}
}
\description{
Performs a one- or two-sample test of proportions using counts of successes and trials, rather than
binary data. This test can be approximate or exact.
}
\details{
If \code{x2} or \code{n2} are specified, then both must be specified, and a two-sample test is run.
}
\examples{
# Two-sample test
proptesti(10, 100, 15, 200, alternative = "less")

}
