% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipc_get_areas.R
\name{ipc_get_areas}
\alias{ipc_get_areas}
\title{Get areas resources from the IPC-CH API}
\usage{
ipc_get_areas(
  country = NULL,
  year = NULL,
  type = NULL,
  id = NULL,
  period = NULL,
  return_format = c("csv", "geojson"),
  api_key = NULL,
  tidy_df = TRUE
)
}
\arguments{
\item{country}{ISO2 country code.}

\item{year}{Single numeric year to filter analysis, calculated from the
maximum year of current period dates. If \code{NULL}, the default, returns
data for all years.}

\item{type}{Single string value of 'A' or 'C', corresponding to food security
conditions, either acute or chronic. If \code{NULL}, the default, returns
data for all types.}

\item{id}{Analysis ID.}

\item{period}{Period code, either 'C', 'P', or 'A' for current, projection,
and second projection.}

\item{return_format}{The format that should be returned by the API. Allows
\code{"csv"} (the default) and \code{"geojson"}.}

\item{api_key}{IPC API key. If \code{NULL} (the default), looks for \code{IPC_API_KEY}
in the environment.}

\item{tidy_df}{If \code{TRUE}, returns a tidy data frame wrangled as described in
the Tidy section of the documentation. If \code{FALSE}, returns
the data frame as returned direct from the IPC-CH API.}
}
\value{
Data frame of IPC and CH analysis at the areas level. Refer to the
\href{https://docs.api.ipcinfo.org}{IPC-CH Public API documentation} for details
on the returned values, with variables described in full in the \href{https://observablehq.com/@ipc/ipc-api-extended-documentation}{extended documentation}.
}
\description{
Accesses the areas resources on the IPC-CH API. Contains detailed area and
population data. If \code{country}, \code{year} and/or \code{type} parameters are passed,
accesses the \strong{areas} simplified API endpoint and pulls in all areas filtered to
those parameters. To get all areas for a specific analysis
and period, available on the \strong{areas/\{id\}/\{period\}} advanced API endpoint,
pass in \code{id} and \code{period}. You cannot pass in both sets of parameters.
}
\details{
Areas data is the typical unit of analysis in IPC-CH outputs. These are
typically administrative units (or clusters of them together). For each area,
estimates of the population in each phase is provided and a general phase
classification is assigned. Use \code{\link[=ipc_get_population]{ipc_get_population()}} to get
detailed population data and classifications for all analysis periods.

See the \href{https://www.ipcinfo.org}{IPC website} and
\href{https://docs.api.ipcinfo.org}{API documentation} for more information.
}
\section{Tidy}{

When \code{tidy_df} is \code{TRUE}, the following changes are made to the initial
output to ensure each row represents a single area analysis, and all estimates
and values are stored as columns:
\enumerate{
\item \code{analysis_period_start} and \code{analysis_period_end} created as \code{Date} columns
from the \code{from} and \code{to} columns respectively, allocating the day of the
start and end periods to be the 15th of the month.
\item \code{title} column is renamed to be \code{area_name}, \code{anl_id} to \code{analysis_id},
and \code{id} and \code{aar_id} are changed to \code{area_id}.
\item Duplicated rows are removed from the data frame if the return value is CSV,
because the duplicates are there due to polygon geometries.
}
}

\examples{
\dontshow{if (!is.na(Sys.getenv("IPC_API_KEY", unset = NA))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# get all areas from the simplified API
ipc_get_areas()

# get areas for specific analysis ID and period from advanced API
ipc_get_areas(id = 12856213, period = "P")

# request GeoJSON return
ipc_get_areas(id = 12856213, period = "P", return_format = "geojson")
\dontshow{\}) # examplesIf}
}
