% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admin.R
\name{iadmin}
\alias{iadmin}
\title{The Administration Interface to iRODS}
\usage{
iadmin(
  name,
  password = character(1),
  action = c("create_user", "set_password", "remove_user"),
  role = c("rodsuser", "groupadmin", "rodsadmin"),
  verbose = FALSE
)
}
\arguments{
\item{name}{Name of user to be added.}

\item{password}{Password to be added.}

\item{action}{The action: \code{"create_user"}, \code{"remove_user"}, or \code{"set_password"}.}

\item{role}{Role of user: \code{"rodsuser"}, \code{"groupadmin"}, and \code{"groupadmin"}.}

\item{verbose}{Show information about the http request and response.
Defaults to \code{FALSE}.}
}
\value{
Invisible http status.
}
\description{
Note that this function can only be used with admin rights.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()

# demonstration server (requires Bash, Docker and Docker-compose)
# use_irods_demo()
\dontshow{
.old_config_dir <- Sys.getenv("R_USER_CONFIG_DIR")
Sys.setenv("R_USER_CONFIG_DIR" = tempdir())
}
# connect project to server
\Sexpr[stage=build, results=rd]{paste0("create_irods(\"", rirods:::.irods_host, "\")")}

# authentication
iauth("rods", "rods")

# add user
iadmin("Alice", action = "create_user", role = "rodsuser")

# add user password
iadmin("Alice", "pass", action = "set_password",  role = "rodsuser")

# delete user
iadmin("Alice", action = "remove_user", role = "rodsuser")
\dontshow{
Sys.setenv("R_USER_CONFIG_DIR" = .old_config_dir)
}
\dontshow{\}) # examplesIf}
}
