% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivs.R
\name{make_derivation_snippet}
\alias{make_derivation_snippet}
\title{Helper function to generate a Nix derivation snippet}
\usage{
make_derivation_snippet(
  out_name,
  src_snippet,
  base,
  build_phase,
  derivation_type,
  noop_build = FALSE
)
}
\arguments{
\item{out_name}{Character, name of the derivation}

\item{src_snippet}{Character, the src part of the derivation}

\item{base}{Character, base name for buildInputs and configurePhase}

\item{build_phase}{Character, the build phase commands}

\item{derivation_type}{Character, one of "rxp_r", "rxp_py", "rxp_jl", "rxp_qmd", "rxp_rmd"}

\item{noop_build}{Logical, defaults to FALSE. If TRUE, the derivation
produces a no-op build (a stub output with no actual build steps). Any
downstream derivations depending on a no-op build will themselves also
become no-op builds.}
}
\value{
Character string with the formatted Nix derivation
}
\description{
Helper function to generate a Nix derivation snippet
}
\keyword{internal}
