% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diftimermst.R
\name{diftimermst}
\alias{diftimermst}
\title{Comparing restricted mean survival time when survival curves have divergent tails}
\usage{
diftimermst(data, tau, alpha = 0.05)
}
\arguments{
\item{data}{The data set must contains three variables named time, arm and event.\cr
time: The follow-up time for right censored.\cr
arm: The group indicator for comparison. 1=treat group, 0=control group.\cr
event: The event indicator, 1=event, 0=right censored.\cr
We assume that control group KM is shoter than treat group.}

\item{tau}{The truncation time point for the RMST calculation. If tau is bigger than the largest observed time in shorter KM, then conduct a sensitivity approach which we propose.}

\item{alpha}{The default is 0.05. 1-alpha confidence intervals are reported.}
}
\value{
list of RMST comparing results.

1. Point estimates

\item{RMST arm=1}{RMST results in treat group.}

\item{RMST arm=0 Method1}{RMST results in control group. Method1:Deal with the censored case as event case.}

\item{RMST arm=0 Method2}{RMST results in control group. Method2:Extend the observation time up to tau and deal with event.}
2. Comparison between two group

\item{RMST difference Method1 (arm=1)-(arm=0)}{Results of the RMST difference in Method1.}

\item{RMST difference Method2 (arm=1)-(arm=0)}{Results of the RMST difference in Method2.}

\item{RMST ratio Method1 (arm=1)/(arm=0)}{Results of the RMST ratio in Method1.}

\item{RMST ratio Method2 (arm=1)/(arm=0)}{Results of the RMST ratio in Method2.}
The values below are generated when several patients are censored at the largest survival time in the shorter-survival group.

1. Point estimates

\item{RMST arm=1}{RMST results in treat group.}

\item{RMST (difference p value=max)}{RMST results in control group. The pattern that maximize the p value when comparing by difference. Usually, the result of Method2 is calculated.}

\item{RMST (difference p value=min)}{RMST results in control group. The pattern that minimize the p value when comparing by difference. Usually, the result of Method1 is calculated.}

\item{RMST (ratio p value=max)}{RMST results in control group. The pattern that maximize the p value when comparing by ratio.}

\item{RMST (ratio p value=min)}{RMST results in control group. The pattern that minimize the p value when comparing by ratio.}
2. Comparison between two group

\item{RMST difference (p value=max)}{Results of the RMST difference when the p value maximum.}

\item{RMST difference (p value=min)}{Results of the RMST difference when the p value minimum.}

\item{RMST ratio (p value=max)}{Results of the RMST ratio when the p value maximum.}

\item{RMST ratio (p value=max)}{Results of the RMST ratio when the p value minimum.}
}
\description{
Performs two-sample comparisons using the restricted mean survival time (RMST) when survival curves end at different time points between groups.
This package implements a sensitivity approach that allows the threshold  timepoint tau to be specified after the longest survival time in the shorter survival group.
Two kinds of between-group contrast estimators (the difference in RMST and the ratio of RMST) are computed.
}
\examples{
#--- sample data ---#
time  <- c(0.7,1.6,3.1,4.5,7.6,11,13.5,18.6,22.7,26.5,0.4,2.2,2.9,3.8,5.2,8.6,9.8,10.1,13.3,14.9)
event <- c(0,1,1,0,0,1,0,1,0,0,0,1,0,1,0,1,0,1,1,0)
arm   <- c(1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0)
data <- data.frame(time,event,arm)
#--- analysis ---#
library(rmstcompsens)
a = diftimermst(data,24)
print(a)

}
\references{
Uno H, Claggett B, Tian L, Inoue E, Gallo P, Miyata T, Schrag D,
Takeuchi M, Uyama Y, Zhao L, Skali H, Solomon S, Jacobus S, Hughes M,
Packer M, Wei LJ. Moving beyond the hazard ratio in quantifying the between-group difference in survival analysis. Journal of clinical Oncology 2014, 32, 2380-2385.

Hajime Uno, Lu Tian, Miki Horiguchi, Angel Cronin, Chakib Battioui and James Bell (2020). survRM2: Comparing Restricted
Mean Survival Time. R package version 1.0-3. https://CRAN.R-project.org/package=survRM2

Ueno K, Morita S. Sensitivity Analysis for Restricted Mean Survival Time When Survival Curves Have Divergent Tails. Ther Innov Regul Sci (2023).
}
\author{
Kentaro Ueno
}
