% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.network_function.R
\name{describe_network}
\alias{describe_network}
\title{A function to describe the evidence base}
\usage{
describe_network(data, drug_names, measure, save_xls)
}
\arguments{
\item{data}{A data-frame of a one-trial-per-row format containing arm-level
data of each trial. See 'Format' in \code{\link{run_model}}.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data}.}

\item{measure}{Character string indicating the effect measure. For a binary
outcome, the following can be considered: \code{"OR"}, \code{"RR"} or
\code{"RD"} for the odds ratio, relative risk, and risk difference,
respectively. For a continuous outcome, the following can be considered:
\code{"MD"}, \code{"SMD"}, or \code{"ROM"} for mean difference,
standardised mean difference and ratio of means, respectively.}

\item{save_xls}{Logical to indicate whether to export the tabulated results
to an 'xlsx' file (via the \code{\link[writexl:write_xlsx]{write_xlsx}}
function of the R-package
\href{https://CRAN.R-project.org/package=writexl}{writexl}) at the working
directory of the user. The default is \code{FALSE} (do not export).}
}
\value{
\code{describe_network} returns the following data-frames that describe the
  evidence base:
  \item{network_description}{The number of: interventions, possible
  comparisons, direct and indirect comparisons, number of trials in total,
  number of two-arm and multi-arm trials, number of randomised participants,
  and proportion of participants completing the trial (completers).
  When the outcome is binary, the number of trials with at least one zero
  event, and the number of trials with all zero events are also
  presented.}
  \item{table_interventions}{For each intervention, the number of trials,
  number of randomised participants, and proportion of completers. When the
  outcome is binary, the data-frame presents also the corresponding
  proportion of total observed events, the minimum, median and maximum
  proportion of observed events across the corresponding trials.}
  \item{table_comparisons}{Identical structure to \code{table_interventions}
  but for each observed comparison in the network.}
}
\description{
Calculates the necessary elements to describe the evidence base
  for an outcome across the network, the interventions, and observed
  comparisons.
}
\details{
\code{describe_network} calls \code{\link{data_preparation}} to
  facilitate the calculations.

  Furthermore, \code{describe_network} exports the data-frames to separate
  'xlsx' files (via the \code{\link[writexl:write_xlsx]{write_xlsx}} function
  of the R-package
  \href{https://CRAN.R-project.org/package=writexl}{writexl}) at the working
  directory of the user.
}
\seealso{
\code{\link{data_preparation}}, \code{\link{run_model}}
  \code{\link[writexl:write_xlsx]{write_xlsx}}
}
\author{
{Loukia M. Spineli}
}
