% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nprop.R
\name{nprop}
\alias{nprop}
\title{Estimate sample size for hypothesis testing on proportions}
\usage{
nprop(p1, p2, alp, pwr, type = "two", alternative = "two.sided", k = 1)
}
\arguments{
\item{p1}{hypothesized or reported proportion}

\item{p2}{anticipated proportion in the population of interest}

\item{alp}{level of significance or accepted level of probability of type I error}

\item{pwr}{desired level of power}

\item{type}{character string stating number of groups i.e. \code{one} or \code{two} (default)}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of \code{two.sided} (default) or \code{one.sided}}

\item{k}{ratio of number of subjects in the two groups \code{k=1} (default)}
}
\value{
a list object, the required minimum sample size along with description for reporting
}
\description{
This function computes the sample size based on two different methods i) comparing proportion with a specified (reference)
value ii) comparing two independent proportions
}
\examples{
nprop(p1=0.5, p2=0.4, alp=0.05, pwr=0.90, type="one",
alternative="one.sided", k=1)
nprop(p1=0.05, p2=0.15, alp=0.05, pwr=0.90, type="two",
alternative="one.sided", k=1)
}
\author{
R. Amala, Scientist-C, ICMR-VCRC, Puducherry  & G. Kumarapandiyan, Asst. Prof., Madras Christian College, Chennai
}
