% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transf.R
\name{clip_bands}
\alias{clip_bands}
\alias{clip_bands.satres}
\title{Clip all the bands based on a polygon}
\usage{
clip_bands(sr, polygon)

\method{clip_bands}{satres}(sr, polygon)
}
\arguments{
\item{sr}{A \code{satres} object.}

\item{polygon}{A \code{sf} polygon layer.}
}
\value{
A \code{satres} object.
}
\description{
Clips all bands of each spatial resolution according to the given polygon.
}
\details{
It performs the operation independently of the CRS of the polygon and preserves
the CRS of the bands.
}
\examples{

file <- system.file("extdata", "lanjaron.gpkg", package = "satres")
lanjaron <- sf::st_read(file, layer = "lanjaron_bbox", quiet = TRUE)

esa <- system.file("extdata", "esa", package = "satres")
sr <- satres(dir = esa) |>
     clip_bands(polygon = lanjaron)

}
\seealso{
\code{\link{satres}}

Other satellite transformation: 
\code{\link{merge_tiles}()},
\code{\link{select_bands}()}
}
\concept{satellite transformation}
