% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlotMatrix.R
\name{highlightPoint}
\alias{highlightPoint}
\title{Row highlight}
\usage{
highlightPoint(id, pointIndex)
}
\arguments{
\item{id}{output variable to read from (id which references the requested plot)}

\item{pointIndex}{index of the point to highlight; \code{NULL} means no point is to highlight.}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Asks to change the highlighted row.
}
\examples{
 if(interactive() && require(shiny)) {
   library(shiny)
   library(scatterPlotMatrix)

   ui <- fluidPage(
     actionButton("highlightPointAction", "Highlight Last Point"),
     actionButton("clearHlPointAction", "Remove Highlighting"),
     p("These buttons sets/unsets a selected line"),
     scatterPlotMatrixOutput("spMatrix")
   )

   server <- function(input, output, session) {
     output$spMatrix <- renderScatterPlotMatrix({
       scatterPlotMatrix(iris)
     })
     observeEvent(input$highlightPointAction, {
       lastRowIndex <- nrow(iris)
       scatterPlotMatrix::highlightPoint("spMatrix", lastRowIndex)
     })

     observeEvent(input$clearHlPointAction, {
       scatterPlotMatrix::highlightPoint("spMatrix", NULL)
     })
   }

   shinyApp(ui, server)
 }

}
