% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grim-granularity.R
\name{grim_granularity}
\alias{grim_granularity}
\alias{grim_items}
\title{Granularity of non-continuous scales}
\usage{
grim_granularity(n, items = 1)

grim_items(n, gran, tolerance = .Machine$double.eps^0.5)
}
\arguments{
\item{n}{Numeric. Sample size.}

\item{items}{Numeric. Number of items composing the scale. Default is 1,
which will hold for most non-Likert scales.}

\item{gran}{Numeric. Granularity.}

\item{tolerance}{Numeric. Any difference between \code{x} and a truncated version
of \code{x} less than \code{tolerance} (in the absolute value) will be ignored. The
default is close to \code{1 / (10 ^ 8)}. This avoids errors due to spurious
precision in floating-point arithmetic.}
}
\value{
Numeric. Granularity or number of items.
}
\description{
\code{grim_granularity()} computes the minimal difference between two
means or proportions of ordinal or interval data.

\code{grim_items()} is the reverse: It converts granularity values to the number
of scale items, which might then be used for consistency testing functions
such as \code{grim()}.
}
\details{
These two functions differ only in the names of their arguments ---
the underlying formula is the same (and it's very simple). However, for
clarity, they are presented as distinct.

The output of \code{grim_items()} should be whole numbers, because scale items
have a granularity of 1.

It would be wrong to determine a scale's granularity from the minimal
distance between two values in a given distribution. This would only
signify how those values actually do differ, not how they \emph{can} differ \emph{a
priori} based on scale design. Also, keep in mind that continuous scales
have no granularity at all.
}
\examples{
# If a non-Likert scale ranges from 0 to 3
# and measures 16 cases:
grim_granularity(n = 16)   # `items = 1` by default

# Same but Likert scale with 2 items:
grim_granularity(n = 16, items = 2)

# If a scale is applied to a single case
# and has a granularity of 0.5:
grim_items(n = 1, gran = 0.5)

# With more cases, a warning appears
# because items can only be whole numbers:
grim_items(n = c(10, 15, 20), gran = 0.5)
}
\references{
Brown, N. J. L., & Heathers, J. A. J. (2017). The GRIM Test: A
Simple Technique Detects Numerous Anomalies in the Reporting of Results in
Psychology. \emph{Social Psychological and Personality Science}, 8(4), 363–369.
https://journals.sagepub.com/doi/10.1177/1948550616673876
}
