% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msdpd.R
\name{msdpd}
\alias{msdpd}
\title{M-estimator for spatial dynamic panel data model}
\usage{
msdpd(
  y,
  x,
  w1,
  correction = TRUE,
  hessian_er = FALSE,
  true_range = FALSE,
  max_try = 5,
  w2 = w1,
  w3 = w1,
  no_tf = FALSE,
  model = "full",
  rcpp = TRUE,
  cma_pop_multi = 1
)
}
\arguments{
\item{y}{matrix, containing regional index (first column), time index (second column, numeric) and dependent variable (third column, numeric).}

\item{x}{matrix, containing regional index (first column), time index (second column, numeric) and regressors (numeric).}

\item{w1}{matrix, the spatial weight matrix. If w2 and w3 are supplied, the spatial weight matrix for spatial lag.}

\item{correction}{logical, whether to use adjusted score function. Default value is TRUE.}

\item{hessian_er}{logical, whether to output hessian based se. Ignored if correction is set to False. Default value is FALSE.}

\item{true_range}{logical, whether to used the accurate stationary check. Default value is FALSE due to performance reasons.}

\item{max_try}{integer, maximum attempt for the solver. Default value is 5.}

\item{w2}{matrix, the spatial weight matrix for spatio-temporal lag. Default value is the same as w1.}

\item{w3}{matrix, the spatial weight matrix for spatial error. Default value is the same as w1.}

\item{no_tf}{logical, whether to account for time effect. Default value is TRUE.}

\item{model}{character, indicates the model used for estimation, can be "full", "slm", "sem", "sltl". See Details.}

\item{rcpp}{logical, whether to use the rcpp implementation to calculate the score function. Default value is TRUE.}

\item{cma_pop_multi}{integer, multiplier for the population size used in CMA-ES. Default value is 1.}
}
\value{
A list of estimation results of S3 class "msdpd"
\itemize{
\item{"coefficient"} {list, coefficients and standard errors}
\item{"model"} {character, model used for estimation}
\item{"vc_mat"} {matrix, variance-covariance matrix}
\item{"hessian"} {matrix, optional, hessian matrix}
}
}
\description{
Estimating the spatial dynamic panel data model with M-estimator
}
\details{
Estimating the spatial dynamic panel data model with Yang(2018)'s M-estimator
\deqn{	y_{ti} = \mu_{i}+\alpha_t + x_{ti}\beta + \rho y_{t-1,i} + \lambda_1 \sum_{j =1}^{n}w_{1,ij}y_{tj} + \lambda_2 \sum_{j =1}^{n}w_{2,ij}y_{t-1,j} +  u_{ti},\\ 
u_{ti} = \lambda_3\sum_{j =1}^{n}w_{3,ij}u_{tj} + v_{ti}, i=1,\ldots,n,t=1,\ldots,T}
The minimum number of time-periods is 4. Make sure the rows and columns of w1, w2, and w3 are lined up with the regional index. 
Sub-models can be specified by argument "model"
\itemize{
\item{"full"} {Full model}
\item{"slm"} {\eqn{\lambda_2 = \lambda_3 = 0}}
\item{"sem"} {\eqn{\lambda_1 = \lambda_2 = 0}}
\item{"sltl"} {\eqn{\lambda_3 = 0}}
}
Some suggestions when the optimizer fails: 
\itemize{
\item{} {Increase max_try}
\item{} {Increase cma_pop_multi}
\item{} {try a different submodel}
}
}
\examples{
\donttest{
data(data_n, data_nw)
result <- msdpd(y = data_n$y, x = data_n$x, w1 = data_nw)
}

}
\references{
Yang, Z. (2018). Unified M-estimation of fixed-effects spatial dynamic models with short panels. Journal of Econometrics, 205(2), 423-447.
}
