% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dot.R
\name{save_plot}
\alias{save_plot}
\title{Saves a SEMinR model plot to file}
\usage{
save_plot(
  filename = "RPlot.pdf",
  plot = last_seminr_plot(),
  width = NULL,
  height = NULL
)
}
\arguments{
\item{filename}{The name of the file output (can be png, pdf, webp, ps, or svg.)}

\item{plot}{A plot that is created from the \code{\link{plot}} function. By default it uses the last plot created.}

\item{width}{An optional parameter for width in pixels.}

\item{height}{An optional parameter for height in pixels.}
}
\value{
Does not return a value
}
\description{
Saves a SEMinR model plot to a graphical file. Default output is RPlots.pdf.
}
\examples{
mobi <- mobi

# seminr syntax for creating measurement model
mobi_mm <- constructs(
             reflective("Image",        multi_items("IMAG", 1:5)),
             reflective("Expectation",  multi_items("CUEX", 1:3)),
             reflective("Quality",      multi_items("PERQ", 1:7)),
             reflective("Value",        multi_items("PERV", 1:2)),
             reflective("Satisfaction", multi_items("CUSA", 1:3)),
             reflective("Complaints",   single_item("CUSCO")),
             reflective("Loyalty",      multi_items("CUSL", 1:3))
           )
# seminr syntax for creating structural model
mobi_sm <- relationships(
  paths(from = "Image",        to = c("Expectation", "Satisfaction", "Loyalty")),
  paths(from = "Expectation",  to = c("Quality", "Value", "Satisfaction")),
  paths(from = "Quality",      to = c("Value", "Satisfaction")),
  paths(from = "Value",        to = c("Satisfaction")),
  paths(from = "Satisfaction", to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)

# estimate the model
mobi_pls <- estimate_pls(data = mobi,
                         measurement_model = mobi_mm,
                         structural_model = mobi_sm)
\dontrun{
# generate the plot
plot(mobi_pls)
# save to file
save_plot("myplot.pdf")
}

}
