% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getControlSubj.R
\name{getControlSubj}
\alias{getControlSubj}
\title{Extract a list of control animals for a list of studies}
\usage{
getControlSubj(dbToken, studyList, inclUncertain = FALSE)
}
\arguments{
\item{dbToken}{Mandatory.\cr
Token for the open database connection (see \code{\link{initEnvironment}}).}

\item{studyList}{Mandatory, data.table.\cr
A table with a list of studies to limit the output to be within this
set of studies.\cr
The table must include a column named 'STUDYID'.}

\item{inclUncertain}{Mandatory, boolean.\cr
Indicates whether animals, which cannot be identified as neither negative
nor positive control (i.e. uncertain animals), shall be included or not in
the output data table.}
}
\value{
The function return a data.table with columns:
\itemize{
\item STUDYID       (character)
\item Additional columns contained in the \code{studyList} table
\item TCNTRL        (character)\cr
The value of the TX parameter TCNTRL which is used for identification
of whether it is a negative control group or not
\item USUBJID       (character)
\item RFSTDTC       (character)
\item DM_AGEDAYS    (integer)\cr
The calculated age in days of the animal at the reference start day
- i.e. the age registered in DM.
\item DSDECOD    (character)\cr
The standardized disposition term for the animal
\item DS_AGEDAYS    (integer)\cr
The calculated age in days of the animal at the disposition
\item NO_AGE_MSG    (character)\cr
Empty or contains the reason if a DM_AGEDAYS couldn't be calculated
\item UNCERTAIN_MSG (character)\cr
Included when parameter \code{inclUncertain=TRUE}.\cr
Contains the reason for an uncertain animal is NA for rows for
confident identified negative control animals.
\item NOT_VALID_MSG (character)\cr
Included if the column is included in data table specified in
\code{studyList},
}
}
\description{
Returns a data table with a list of animals belonging to the groups for
negative control in the given list of studies.\cr
}
\details{
The set of animals contains all animals from DM where the SETCD
is associated with a TX parameter 'TCNTRL'. Negative control animals are
further defined by
\itemize{
\item  either containing a word from a set of words, to
automatically distinguish it as a negative control:
\itemize{
\item ['placebo', 'untreated', 'sham']
}
\item or containing a combination of a word  from of two lists:
\enumerate{
\item ['negative', 'saline', 'peg', 'vehicle', 'citrate', 'dextrose', 'water', 'air']
\item ['item', 'control', 'article']
}
}
Animals are in all cases excluded (i.e. whether \code{inclUncertain=TRUE} or
\code{inclUncertain=FALSE}) from the output set, when they are identified as
positive control animals - i.e. they are associated with a TX parameter
'TCNTRL' containing a word from this set of words:
\itemize{
\item ['positive','reference']
}

The age in days at reference start date is calculated for each animal based
on the age related variables in DM:
\enumerate{
\item If BRTHDTC is populated compute DM.RFSTDTC – DM.BRTHDTC + 1
\item Else If AGE is populated convert from units specified in AGEU to days.
\item Else If AGETXT is populated convert the mid-point of the range from
units specified in AGEU to days.\cr
These AGEU units are handled with the described conversion from value to
number of days:
\itemize{
\item DAYS
\item WEEKS   : value * 7
\item MONTHS  : value * 365/12
\item YEARS   : value * 365
}
}
If input parameter \code{inclUncertain=TRUE}, uncertain animals are included
in the output set. These uncertain situations are identified and reported (in
column UNCERTAIN_MSG):
\itemize{
\item TX parameter 'TCNTRL' is missing
\item TXVAL for TX parameter 'TCNTRL' cannot be identified as Negative or
Positive control according to the algorithm described above
}
}
\examples{
\dontrun{
controlAnimals <- getControlSubj(myDbToken, allSTudies)
}
}
