% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_seromodel.R
\name{prepare_serosurvey_for_plot}
\alias{prepare_serosurvey_for_plot}
\title{Prepares serosurvey for plotting}
\usage{
prepare_serosurvey_for_plot(serosurvey, alpha = 0.05)
}
\arguments{
\item{serosurvey}{\describe{
\item{\code{survey_year}}{Year in which the survey took place
(only needed to plot time models)}
\item{\code{age_min}}{Floor value of the average between age_min and age_max}
\item{\code{age_max}}{The size of the sample}
\item{\code{n_sample}}{Number of samples for each age group}
\item{\code{n_seropositive}}{Number of positive samples for each age group}
}}

\item{alpha}{1 - alpha indicates the confidence level to be used}
}
\value{
serosurvey with additional columns:
\describe{
\item{seroprev}{Seroprevalence computed as the proportion of positive
cases \code{n_seropositive} in the number of samples
\code{n_sample} for each age group}
\item{seroprev_lower}{Lower limit of the binomial confidence interval
of \code{seroprev}}
\item{seroprev_upper}{Upper limit of the binomial confidence interval
of \code{seroprev}}
}
}
\description{
Adds seroprevalence values with corresponding binomial confidence interval
}
