% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_continuous_sg.R
\name{scale_colour_continuous_sg}
\alias{scale_colour_continuous_sg}
\alias{scale_fill_continuous_sg}
\title{Continuous colour/fill scales for Scottish Government plots}
\usage{
scale_colour_continuous_sg(
  palette = "sequential",
  palette_type = "sg",
  reverse = FALSE,
  na_colour = "grey50",
  guide = "colourbar",
  ...
)

scale_fill_continuous_sg(
  palette = "sequential",
  palette_type = "sg",
  reverse = FALSE,
  na_colour = "grey50",
  guide = "colourbar",
  ...
)
}
\arguments{
\item{palette}{Name of palette to use; e.g. "main", "sequential", "focus".
Default value is "sequential".}

\item{palette_type}{Name of palette type to use. Defaults to "sg". For all
available palette types, run \code{available_palette_types()}.}

\item{reverse}{Boolean value to indicate whether the palette should be
reversed.}

\item{na_colour}{Colour to set for missing values.}

\item{guide}{A name or function used to create guide. Default is "colourbar".}

\item{...}{Additional arguments passed to scale type.}
}
\value{
ggplot2 continuous colour/fill scale
}
\description{
Continuous colour/fill scales for Scottish Government plots
}
\examples{
library(ggplot2)

ggplot(mtcars, aes(x = mpg, y = wt, colour = cyl)) +
  geom_point() +
  scale_colour_continuous_sg()

ggplot(faithfuld, aes(x = waiting, y = eruptions, fill = density)) +
  geom_raster() +
  scale_fill_continuous_sg()

}
