% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_files.R
\name{load_files}
\alias{load_files}
\title{Load Files}
\usage{
load_files(
  folder,
  filetype = ".csv",
  data_cleaning_function = NULL,
  id_by_filename = FALSE,
  id_col_name = "index"
)
}
\arguments{
\item{folder}{Folder where the files to be read in are located (required)}

\item{filetype}{Set whether to read in .xlsx or .csv files. It takes either ".xlsx" or ".csv". By default, it is set to ".csv" (required)}

\item{data_cleaning_function}{Add a custom data cleaning function built for individual files. Use no brackets when referencing the function, for example clean_data_from_data_logger. The function being added must be saved in the environment (optional)}

\item{id_by_filename}{Logical. If set to TRUE, the output will contain a column, storing the name of each file being read in. Ideally, the names of the individual files should be pertinent to their content, e.g. if 20 files are being read in with experimental data from parts 1 through 20, the files should be named 1-20. (optional)}

\item{id_col_name}{Specify a name for the .id column. By default, it is set to "index" (optional)}
}
\value{
Returns data in the form of a \code{tibble} object.
}
\description{
Reads a series of either .xlsx or .csv files into a table. Particularly useful when reading in multiple files having the same variables, for example reading in data from an experiment where data was logged and saved separately for each individual unit. Integration of a custom data cleaning function.
}
