% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R,
%   R/inputs.R
\name{Rating}
\alias{Rating}
\alias{Rating.shinyInput}
\alias{updateRating.shinyInput}
\title{Rating}
\usage{
Rating(...)

Rating.shinyInput(inputId, ..., value = defaultValue)

updateRating.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).
}
\description{
Ratings show people’s opinions of a product, helping others make more informed purchasing decisions. People can also rate products they’ve purchased.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Rating}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item \bold{ allowZeroStars } \code{boolean} \cr Allow the rating value to be set to 0 instead of a minimum of 1.
\item \bold{ ariaLabelFormat } \code{string} \cr Optional label format for a rating star that will be read by screen readers. Can be used like "\{0\} of \{1\} stars selected", where \{0\} will be substituted by the current rating and \{1\} will be substituted by the max rating.
\item \bold{ ariaLabelId } \code{string} \cr Deprecated: Optional id of label describing this instance of Rating.
\item \bold{ componentRef } \verb{IRefObject<IRating>} \cr Optional callback to access the IRating interface. Use this instead of ref for accessing the public methods and properties of the component.
\item \bold{ getAriaLabel } \verb{(rating: number, max: number) => string} \cr
\item \bold{ icon } \code{string} \cr Custom icon
\item \bold{ max } \code{number} \cr Maximum rating, defaults to 5, has to be \>= min
\item \bold{ min } \code{number} \cr Minimum rating, defaults to 1, has to be \>= 0
\item \bold{ onChange } \verb{(event: React.FocusEvent<HTMLElement>, rating?: number) => void} \cr Callback issued when the rating changes.
\item \bold{ onChanged } \verb{(rating: number) => void} \cr
\item \bold{ rating } \code{number} \cr Selected rating, has to be an integer between min and max
\item \bold{ readOnly } \code{boolean} \cr Optional flag to mark rating control as readOnly
\item \bold{ size } \code{RatingSize} \cr Size of rating, defaults to small
\item \bold{ styles } \verb{IStyleFunctionOrObject<IRatingStyleProps, IRatingStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.
\item \bold{ theme } \code{ITheme} \cr Theme (provided through customization.)
\item \bold{ unselectedIcon } \code{string} \cr Custom icon for unselected rating elements.
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Make it clear which item the rating pertains to by making sure the layout and grouping are clear when several items are on the page.
\item Don't use the rating component for data that has a continuous range, such as the brightness of a photo. Instead, use a slider.
}
}

\subsection{Content}{
\itemize{
\item Use a five-star rating system.
\item Use sentence-style capitalization—only capitalize the first word. For more info, see \href{https://docs.microsoft.com/style-guide/capitalization}{Capitalization} in the Microsoft Writing Style Guide.
}
}
}

\examples{
library(shiny)
library(shiny.fluent)

ui <- function(id) {
  ns <- NS(id)
  div(
    Rating.shinyInput(ns("rating"), value = 2),
    textOutput(ns("ratingValue"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$ratingValue <- renderText({
      sprintf("Value: \%s", input$rating)
    })
  })
}

if (interactive()) {
  shinyApp(ui("app"), function(input, output) server("app"))
}
}
