% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cookieBanner.R
\name{cookieBanner}
\alias{cookieBanner}
\title{Cookie Banner Function}
\usage{
cookieBanner(service_name)
}
\arguments{
\item{service_name}{Name for this service to add to banner}
}
\value{
a cookie banner html shiny object.
}
\description{
This function creates a cookie banner. You need to have shinyjs::useShinyjs()
enabled to work.  All the ids are pre set.  See example for how to
structure.
}
\examples{
if (interactive()) {
ui <- fluidPage(
  shinyGovstyle::header(
    main_text = "Example",
    secondary_text = "User Examples",
    logo="shinyGovstyle/images/moj_logo.png"),
  #Needs shinyjs to work
  shinyjs::useShinyjs(),
  shinyGovstyle::cookieBanner("The best thing"),
  shinyGovstyle::gov_layout(size = "two-thirds"),
  shinyGovstyle::footer(full = TRUE)
)

server <- function(input, output, session) {

  #Need these set of observeEvent to create a path through the cookie banner
  observeEvent(input$cookieAccept, {
    shinyjs::show(id = "cookieAcceptDiv")
    shinyjs::hide(id = "cookieMain")
  })

  observeEvent(input$cookieReject, {
    shinyjs::show(id = "cookieRejectDiv")
    shinyjs::hide(id = "cookieMain")
  })

  observeEvent(input$hideAccept, {
    shinyjs::toggle(id = "cookieDiv")
  })

  observeEvent(input$hideReject, {
    shinyjs::toggle(id = "cookieDiv")
  })

  observeEvent(input$cookieLink, {
    #Need to link here to where further info is located.  You can use
    #updateTabsetPanel to have a cookie page for instance
  })

}
shinyApp(ui = ui, server = server)
}
}
\keyword{banner}
\keyword{cookie}
