% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_correlated_data.R
\name{genCorMat}
\alias{genCorMat}
\title{Create a correlation matrix}
\usage{
genCorMat(nvars, cors = NULL, rho = NULL, corstr = "cs", nclusters = 1)
}
\arguments{
\item{nvars}{number of rows and columns (i.e. number of variables) for correlation matrix. It can be
a scalar or vector (see details).}

\item{cors}{vector of correlations.}

\item{rho}{Correlation coefficient, \code{-1 <= rho <= 1}. Use if corMatrix is not provided. It can
be a scalar or vector (see details).}

\item{corstr}{Correlation structure. Options include "cs" for a compound symmetry structure, "ar1" 
for an autoregressive structure of order 1, "arx" for an autoregressive structure 
that has a general decay pattern, and "structured" that imposes a prescribed
pattern between observation based on distance (see details).}

\item{nclusters}{An integer that indicates the number of matrices that will be generated.}
}
\value{
A single correlation matrix of size \code{nvars x nvars}, or a list of matrices of potentially
different sizes with length indicated by \code{nclusters}.
}
\description{
Create a correlation matrix
}
\details{
This function can generate correlation matrices randomly or deterministically, 
depending on the combination of arguments provided. A single matrix will be
generated when \code{nclusters == 1} (the default), and a list of matrices of matrices will be generated when
\code{nclusters > 1}.

If the vector `cors` is specified with length `nvars - 1` then `corstr` must be "structured". If
`cors` is specified with length `choose(nvars, 2)` then `corstr` should not be specified as
"structured". In this case the `cors` vector should be interpreted as the lower triangle of the correlation
matrix, and is specified by reading down the columns. For example, if \bold{CM} is the correlation matrix and
\code{nvars = 3}, then \code{CM[2,1] = CM[1,2] = cors[1]},  \code{CM[3,1] = CM[1,3] = cors[2]}, 
and \code{CM[3,2] = CM[2,3] = cors[3]}.

If the vector \code{cors} and \code{rho} are not specified, random correlation matrices are generated
based on the specified \code{corstr}. If the structure is "arx", then a random vector of 
length \code{nvars - 1} is randomly generated and sorted in descending order; the correlation matrix
will be generated base on this set of structured correlations. If the structure is \emph{not} specified
as "arx" then a random positive definite of dimensions nvars x nvars with no structural 
assumptions is generated.

If \code{cors} is not specified but \code{rho} is specified, then a matrix with either a "cs" or "ar1" 
structure is generated.

If \code{nclusters > 1}, \code{nvars} can be of length 1 or \code{nclusters}. If it is of length 1,
each cluster will have correlation matrices with the same dimension. Likewise, if \code{nclusters > 1}, 
\code{rho} can be of length 1 or \code{nclusters}. If length of \code{rho} is 1,
each cluster will have correlation matrices with the same autocorrelation.
}
\examples{
genCorMat(nvars = 3, cors = c(.3, -.2, .1))
genCorMat(nvars = 3)

genCorMat(nvars = 4, c(.3, -.2, .1, .2, .5, .2))
genCorMat(4)

genCorMat(nvars = 4, cors = c(.3, .2, .1), corstr = "structured") 
genCorMat(nvars = 4, corstr = "arx") 

genCorMat(nvars = 4, rho = .4, corstr = "cs") 
genCorMat(nvars = 4, rho = .4, corstr = "ar1") 

genCorMat(nvars = c(3, 2, 5), rho = c(.4, .8, .7), corstr = "ar1", nclusters = 3) 

}
\concept{correlated}
