% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smap.R
\name{smap}
\alias{smap}
\alias{smap.leaflet}
\alias{smap.sf}
\alias{smap.default}
\alias{smap.sfc}
\alias{smap.sfg}
\alias{smap.matrix}
\title{View spatial objects as interactive leaflet maps}
\usage{
smap(
  x,
  ...,
  tools = TRUE,
  provider = getOption("smap.providers", "OpenStreetMap")
)

\method{smap}{leaflet}(
  x,
  ...,
  tools = TRUE,
  provider = getOption("smap.providers", "OpenStreetMap")
)

\method{smap}{sf}(
  x,
  ...,
  tools = TRUE,
  provider = getOption("smap.providers", "OpenStreetMap")
)

\method{smap}{default}(
  x,
  labels = NULL,
  ...,
  tools = TRUE,
  provider = getOption("smap.providers", "OpenStreetMap")
)

\method{smap}{sfc}(
  x,
  ...,
  tools = TRUE,
  provider = getOption("smap.providers", "OpenStreetMap")
)

\method{smap}{sfg}(
  x,
  ...,
  tools = TRUE,
  provider = getOption("smap.providers", "OpenStreetMap")
)

\method{smap}{matrix}(
  x,
  labels = NULL,
  ...,
  tools = TRUE,
  provider = getOption("smap.providers", "OpenStreetMap")
)
}
\arguments{
\item{x}{any input supported by \code{\link[=smart_as_sf]{smart_as_sf()}} or a \link[leaflet:leaflet]{leaflet} map
\itemize{
\item a \code{matrix}: Either a matrix with named \code{longitude} and \code{latitude} columns
or an unnamed two column matrix containing longitude and latitude
(in that order)
\item a \code{data.frame} with named \code{longitude} and \code{latitude} columns
\item an \link[sf:sfc]{sf::sfc_POINT} object
\item a named or unnamed \code{numeric} vector of length 2 containing a single
longitude-latitude coordinate pair
\item a \code{character} scalar path or URL to a shapefile or zipped shapefile
\item a \code{leaflet} map
}}

\item{...}{passed on to methods.}

\item{tools}{\code{logical} scalar. If \code{TRUE} show additional tools on the
resulting map (such as a ruler and the ability to switch between several
background tiles)}

\item{provider}{\code{character} vector. Name of one or several valid providers
for \code{\link[leaflet:addProviderTiles]{leaflet::addProviderTiles()}}. If \code{tools == TRUE} you will be able
to switch interactively between all supplied providers on the returned
leaflet map, if \code{tools == FALSE} only the first provider will be used.}

\item{labels}{an optional \code{character} vector of popup labels}
}
\value{
a \link[leaflet:leaflet]{leaflet::leaflet} object
}
\description{
Can be used to preview spatial \R objects
}
\examples{
wp <- matrix(
  c(16.419684, 48.186065,
    16.373894, 48.207853,
    16.285887, 48.083053),
  byrow = TRUE,
  ncol = 2
)

\donttest{
smap(wp)
smap(c(16.419684, 48.186065))
}
}
