% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hail_dataframe.R
\name{hail_dataframe}
\alias{hail_dataframe}
\title{Create a Dataframe}
\usage{
hail_dataframe(x)
}
\arguments{
\item{x}{a hail MatrixTable}
}
\value{
A spark dataframe
}
\description{
This function converts a hail MatrixTable in a dataframe.
}
\examples{
\dontrun{
library(sparklyr)

sc <- spark_connect(master = "local", version = "2.4", config = hail_config())

hl <- hail_context(sc)
mt <- hail_read_matrix(hl, system.file("extdata/1kg.mt", package = "sparkhail"))

df <- hail_dataframe(mt)
df
}
}
